/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlRadioRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlRadioRendererBase.class.getName());
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        UISelectOne selectOne = (UISelectOne)uiComponent;
        String layout = this.getLayout(selectOne);
        boolean pageDirectionLayout = false;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.severe("Wrong layout attribute for component " + selectOne.getClientId(facesContext) + ": " + layout);
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("table", selectOne);
        HtmlRendererUtils.renderHTMLAttributes(writer, selectOne, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        if (behaviors != null && !behaviors.isEmpty()) {
            writer.writeAttribute("id", selectOne.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, selectOne, facesContext);
        }
        if (!pageDirectionLayout) {
            writer.startElement("tr", selectOne);
        }
        List selectItemList = RendererUtils.getSelectItemList(selectOne, facesContext);
        Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, selectOne);
        String currentValue = RendererUtils.getStringFromSubmittedValueOrLocalValueReturnNull(facesContext, selectOne);
        int itemNum = 0;
        for (SelectItem selectItem : selectItemList) {
            itemNum = this.renderGroupOrItemRadio(facesContext, selectOne, selectItem, currentValue, converter, pageDirectionLayout, itemNum);
        }
        if (!pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UIComponent selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getLayout();
        }
        return (String)selectOne.getAttributes().get("layout");
    }

    protected String getStyleClass(UISelectOne selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getStyleClass();
        }
        return (String)selectOne.getAttributes().get("styleClass");
    }

    protected int renderGroupOrItemRadio(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, Object currentValue, Converter converter, boolean pageDirectionLayout, Integer itemNum) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        UISelectOne selectOne = (UISelectOne)uiComponent;
        if (isSelectItemGroup) {
            SelectItem[] selectItems;
            if (pageDirectionLayout) {
                writer.startElement("tr", selectOne);
            }
            writer.startElement("td", selectOne);
            if (selectItem.isEscape()) {
                writer.writeText(selectItem.getLabel(), "label");
            } else {
                writer.write(selectItem.getLabel());
            }
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
                writer.startElement("tr", selectOne);
            }
            writer.startElement("td", selectOne);
            writer.startElement("table", selectOne);
            writer.writeAttribute("border", "0", null);
            if (!pageDirectionLayout) {
                writer.startElement("tr", selectOne);
            }
            SelectItemGroup group = (SelectItemGroup)selectItem;
            for (SelectItem groupSelectItem : selectItems = group.getSelectItems()) {
                itemNum = this.renderGroupOrItemRadio(facesContext, selectOne, groupSelectItem, currentValue, converter, pageDirectionLayout, itemNum);
            }
            if (!pageDirectionLayout) {
                writer.endElement("tr");
            }
            writer.endElement("table");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        } else {
            boolean itemChecked;
            String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectOne, converter, selectItem.getValue());
            boolean bl = itemStrValue == null ? itemStrValue == currentValue : ("".equals(itemStrValue) ? currentValue == null || itemStrValue.equals(currentValue) : (itemChecked = itemStrValue.equals(currentValue)));
            if (HtmlRendererUtils.isHideNoSelectionOption(uiComponent) && selectItem.isNoSelectionOption() && currentValue != null && !"".equals(currentValue) && !itemChecked) {
                return itemNum;
            }
            writer.write("\t\t");
            if (pageDirectionLayout) {
                writer.startElement("tr", selectOne);
            }
            writer.startElement("td", selectOne);
            boolean itemDisabled = selectItem.isDisabled();
            String itemId = this.renderRadio(facesContext, selectOne, itemStrValue, itemDisabled, itemChecked, false, itemNum);
            boolean componentDisabled = this.isDisabled(facesContext, selectOne);
            boolean disabled = componentDisabled || itemDisabled;
            HtmlRendererUtils.renderLabel(writer, (UIComponent)selectOne, itemId, selectItem, disabled);
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
            Integer n = itemNum;
            Integer n2 = itemNum = Integer.valueOf(itemNum + 1);
        }
        return itemNum;
    }

    @Deprecated
    protected void renderRadio(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean disabled, boolean checked, boolean renderId) throws IOException {
        this.renderRadio(facesContext, (UIInput)uiComponent, value, disabled, checked, renderId, 0);
    }

    protected String renderRadio(FacesContext facesContext, UIInput uiComponent, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = itemNum == null ? null : clientId + UINamingContainer.getSeparatorChar(facesContext) + itemNum;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", itemId, null);
        } else if (renderId) {
            writer.writeAttribute("id", clientId, null);
        }
        writer.writeAttribute("type", "radio", null);
        writer.writeAttribute("name", clientId, null);
        if (disabled) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        if (checked) {
            writer.writeAttribute("checked", "checked", null);
        }
        if (value != null) {
            writer.writeAttribute("value", value, null);
        } else {
            writer.writeAttribute("value", "", null);
        }
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors();
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(uiComponent);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderChangeEventProperty(writer, commonPropertiesMarked, uiComponent);
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, uiComponent);
                CommonPropertyUtils.renderFieldEventPropertiesWithoutOnchange(writer, commonPropertiesMarked, uiComponent);
            } else {
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(uiComponent);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, uiComponent, behaviors);
                }
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE_AND_EVENTS);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", Boolean.TRUE, null);
        }
        writer.endElement("input");
        return itemId;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UIInput) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        }
        if (uiComponent instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(uiComponent)) {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, uiComponent);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        return RendererUtils.getConvertedUISelectOneValue(facesContext, (UISelectOne)uiComponent, submittedValue);
    }
}

