/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PageSelectorToolArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;

public class SelectedPages
extends AbstractTool {
    static /* synthetic */ Class class$0;

    static {
        SelectedPages.addVersion("$Id: SelectedPages.java,v 1.8 2006/08/24 10:51:06 blowagie Exp $");
    }

    public SelectedPages() {
        this.menuoptions = 3;
        FileArgument inputfile = new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter());
        this.arguments.add(inputfile);
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the first part of the original PDF has to be written", true, new PdfFilter()));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageSelectorToolArgument spfpdf = new PageSelectorToolArgument(this, "selection", "A selection of pages (see Help for more info)", clazz.getName());
        this.arguments.add(spfpdf);
        inputfile.addPropertyChangeListener(spfpdf);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("SelectedPages", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== SelectedPages OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file for the first part of the PDF");
            }
            File dest = (File)this.getValue("destfile");
            String selection = (String)this.getValue("selection");
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            System.out.println("The original file had " + reader.getNumberOfPages() + " pages.");
            reader.selectPages(selection);
            int pages = reader.getNumberOfPages();
            System.err.println("The new file has " + pages + " pages.");
            Document document = new Document(reader.getPageSizeWithRotation(1));
            PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(dest.getAbsolutePath()));
            document.open();
            int i = 0;
            while (i < pages) {
                System.out.println("Processed page " + ++i);
                PdfImportedPage page = copy.getImportedPage(reader, i);
                copy.addPage(page);
            }
            PRAcroForm form = reader.getAcroForm();
            if (form != null) {
                copy.copyAcroForm(reader);
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
        System.out.println("klasse:" + arg.getClassname());
        System.out.println("arg:" + arg.getValue());
    }

    public static void main(String[] args) {
        SelectedPages tool = new SelectedPages();
        if (args.length < 4) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

