/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.exporter.util;

import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.PropertyNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ComponentUtils {
    private static final Log log = LogFactory.getLog(ComponentUtils.class);

    public static UIComponent findComponentById(FacesContext context, UIComponent root, String id) {
        UIComponent component = null;
        for (int i = 0; i < root.getChildCount() && component == null; ++i) {
            UIComponent child = (UIComponent)root.getChildren().get(i);
            component = ComponentUtils.findComponentById(context, child, id);
        }
        if (root.getId() != null && component == null && root.getId().equals(id)) {
            component = root;
        }
        return component;
    }

    public static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        ComponentUtils.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        ComponentUtils.getPathToComponent(component.getParent(), buf);
    }

    private static Object getValue(UIComponent component) {
        Object value;
        try {
            value = ((ValueHolder)component).getValue();
        }
        catch (Exception ex) {
            throw new FacesException("Could not retrieve value of component with path : " + ComponentUtils.getPathToComponent(component), (Throwable)ex);
        }
        return value;
    }

    public static String getStringValue(FacesContext facesContext, UIComponent component) {
        try {
            EditableValueHolder holder;
            Object submittedValue;
            if (!(component instanceof ValueHolder)) {
                throw new IllegalArgumentException("Component : " + ComponentUtils.getPathToComponent(component) + "is not a ValueHolder");
            }
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                if (submittedValue instanceof String) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returning 1 '" + submittedValue + "'"));
                    }
                    return (String)submittedValue;
                }
                throw new IllegalArgumentException("Expected submitted value of type String for component : " + ComponentUtils.getPathToComponent(component));
            }
            Object value = component instanceof EditableValueHolder ? ((holder = (EditableValueHolder)component).isLocalValueSet() ? holder.getLocalValue() : ComponentUtils.getValue(component)) : ComponentUtils.getValue(component);
            Converter converter = ((ValueHolder)component).getConverter();
            if (converter == null && value != null) {
                try {
                    converter = facesContext.getApplication().createConverter(value.getClass());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("the created converter is " + converter));
                    }
                }
                catch (FacesException e) {
                    log.error((Object)("No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ")."));
                }
            }
            if (converter == null) {
                if (value == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"returning an empty string");
                    }
                    return "";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"returning an .toString");
                }
                return value.toString();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("returning converter get as string " + converter));
            }
            return converter.getAsString(facesContext, component, value);
        }
        catch (PropertyNotFoundException ex) {
            log.error((Object)("Property not found - called by component : " + ComponentUtils.getPathToComponent(component)), (Throwable)ex);
            throw ex;
        }
    }

    public static List getHTMLDataTableColumns(HtmlDataTable table) {
        ArrayList<UIComponent> columns = new ArrayList<UIComponent>();
        for (int i = 0; i < table.getChildCount(); ++i) {
            UIComponent child = (UIComponent)table.getChildren().get(i);
            if (!(child instanceof UIColumn)) continue;
            columns.add(child);
        }
        return columns;
    }
}

