/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum MontgomeryCurve implements KeySizeIndicator,
OptionalFeature
{
    x25519("X25519", 32, BuiltinDigests.sha256, new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 110, 3, 33, 0}),
    x448("X448", 56, BuiltinDigests.sha512, new byte[]{48, 66, 48, 5, 6, 3, 43, 101, 111, 3, 57, 0});

    private final String algorithm;
    private final int keySize;
    private final boolean supported;
    private final DigestFactory digestFactory;
    private final KeyPairGenerator keyPairGenerator;
    private final KeyFactory keyFactory;
    private final byte[] encodedPublicKeyPrefix;

    private MontgomeryCurve(String algorithm, int keySize, DigestFactory digestFactory, byte[] encodedPublicKeyPrefix) {
        boolean supported;
        this.algorithm = algorithm;
        this.keySize = keySize;
        this.digestFactory = digestFactory;
        this.encodedPublicKeyPrefix = encodedPublicKeyPrefix;
        KeyPairGenerator generator = null;
        KeyFactory factory = null;
        try {
            SecurityUtils.getKeyAgreement(algorithm);
            generator = SecurityUtils.getKeyPairGenerator(algorithm);
            factory = SecurityUtils.getKeyFactory(algorithm);
            supported = true;
        }
        catch (GeneralSecurityException ignored) {
            supported = false;
        }
        this.supported = supported && digestFactory.isSupported();
        this.keyPairGenerator = generator;
        this.keyFactory = factory;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    public KeyAgreement createKeyAgreement() throws GeneralSecurityException {
        return SecurityUtils.getKeyAgreement(this.algorithm);
    }

    public Digest createDigest() {
        return (Digest)this.digestFactory.create();
    }

    public KeyPair generateKeyPair() {
        return this.keyPairGenerator.generateKeyPair();
    }

    public byte[] encode(PublicKey key) throws InvalidKeyException {
        byte[] subjectPublicKeyInfo = key.getEncoded();
        byte[] result = Arrays.copyOfRange(subjectPublicKeyInfo, subjectPublicKeyInfo.length - this.getKeySize(), subjectPublicKeyInfo.length);
        return result;
    }

    public PublicKey decode(byte[] key) throws InvalidKeySpecException {
        int size = this.getKeySize();
        int offset = key.length - size;
        if (offset < 0 || offset > 1) {
            throw new InvalidKeySpecException("Provided key has wrong length (" + key.length + " bytes) for " + this.getAlgorithm());
        }
        if (offset == 1 && key[0] != 0) {
            throw new InvalidKeySpecException("Provided key for " + this.getAlgorithm() + " has extra byte, but it's non-zero: 0x" + Integer.toHexString(key[0] & 0xFF));
        }
        byte[] encoded = Arrays.copyOf(this.encodedPublicKeyPrefix, this.encodedPublicKeyPrefix.length + size);
        System.arraycopy(key, offset, encoded, this.encodedPublicKeyPrefix.length, size);
        return this.keyFactory.generatePublic(new X509EncodedKeySpec(encoded));
    }
}

