/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.apache.maven.api.services.MavenException;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalExt;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.ColorPalette;
import org.jline.utils.InfoCmp;
import org.jline.utils.NonBlockingReader;

public class FastTerminal
implements TerminalExt {
    private final CompletableFuture<Terminal> terminal = new CompletableFuture();

    public FastTerminal(Callable<Terminal> builder, Consumer<Terminal> consumer) {
        new Thread(() -> {
            try {
                Terminal term = (Terminal)builder.call();
                consumer.accept(term);
                this.terminal.complete(term);
            }
            catch (Exception e) {
                this.terminal.completeExceptionally((Throwable)new MavenException((Throwable)e));
            }
        }, "fast-terminal-thread").start();
    }

    public TerminalExt getTerminal() {
        try {
            return (TerminalExt)this.terminal.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.getTerminal().getName();
    }

    public Terminal.SignalHandler handle(Terminal.Signal signal, Terminal.SignalHandler signalHandler) {
        return this.getTerminal().handle(signal, signalHandler);
    }

    public void raise(Terminal.Signal signal) {
        this.getTerminal().raise(signal);
    }

    public NonBlockingReader reader() {
        return this.getTerminal().reader();
    }

    public PrintWriter writer() {
        return this.getTerminal().writer();
    }

    public Charset encoding() {
        return this.getTerminal().encoding();
    }

    public InputStream input() {
        return this.getTerminal().input();
    }

    public OutputStream output() {
        return this.getTerminal().output();
    }

    public boolean canPauseResume() {
        return this.getTerminal().canPauseResume();
    }

    public void pause() {
        this.getTerminal().pause();
    }

    public void pause(boolean b) throws InterruptedException {
        this.getTerminal().pause(b);
    }

    public void resume() {
        this.getTerminal().resume();
    }

    public boolean paused() {
        return this.getTerminal().paused();
    }

    public Attributes enterRawMode() {
        return this.getTerminal().enterRawMode();
    }

    public boolean echo() {
        return this.getTerminal().echo();
    }

    public boolean echo(boolean b) {
        return this.getTerminal().echo(b);
    }

    public Attributes getAttributes() {
        return this.getTerminal().getAttributes();
    }

    public void setAttributes(Attributes attributes) {
        this.getTerminal().setAttributes(attributes);
    }

    public Size getSize() {
        return this.getTerminal().getSize();
    }

    public void setSize(Size size) {
        this.getTerminal().setSize(size);
    }

    public int getWidth() {
        return this.getTerminal().getWidth();
    }

    public int getHeight() {
        return this.getTerminal().getHeight();
    }

    public Size getBufferSize() {
        return this.getTerminal().getBufferSize();
    }

    public void flush() {
        this.getTerminal().flush();
    }

    public String getType() {
        return this.getTerminal().getType();
    }

    public boolean puts(InfoCmp.Capability capability, Object ... objects) {
        return this.getTerminal().puts(capability, objects);
    }

    public boolean getBooleanCapability(InfoCmp.Capability capability) {
        return this.getTerminal().getBooleanCapability(capability);
    }

    public Integer getNumericCapability(InfoCmp.Capability capability) {
        return this.getTerminal().getNumericCapability(capability);
    }

    public String getStringCapability(InfoCmp.Capability capability) {
        return this.getTerminal().getStringCapability(capability);
    }

    public Cursor getCursorPosition(IntConsumer intConsumer) {
        return this.getTerminal().getCursorPosition(intConsumer);
    }

    public boolean hasMouseSupport() {
        return this.getTerminal().hasMouseSupport();
    }

    public Terminal.MouseTracking getCurrentMouseTracking() {
        return this.getTerminal().getCurrentMouseTracking();
    }

    public boolean trackMouse(Terminal.MouseTracking mouseTracking) {
        return this.getTerminal().trackMouse(mouseTracking);
    }

    public MouseEvent readMouseEvent() {
        return this.getTerminal().readMouseEvent();
    }

    public MouseEvent readMouseEvent(IntSupplier intSupplier) {
        return this.getTerminal().readMouseEvent(intSupplier);
    }

    public MouseEvent readMouseEvent(String prefix) {
        return this.getTerminal().readMouseEvent(prefix);
    }

    public MouseEvent readMouseEvent(IntSupplier reader, String prefix) {
        return this.getTerminal().readMouseEvent(reader, prefix);
    }

    public boolean hasFocusSupport() {
        return this.getTerminal().hasFocusSupport();
    }

    public boolean trackFocus(boolean b) {
        return this.getTerminal().trackFocus(b);
    }

    public ColorPalette getPalette() {
        return this.getTerminal().getPalette();
    }

    public void close() throws IOException {
        this.getTerminal().close();
    }

    public TerminalProvider getProvider() {
        return this.getTerminal().getProvider();
    }

    public SystemStream getSystemStream() {
        return this.getTerminal().getSystemStream();
    }
}

