/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.Objects;
import org.apache.lucene.monitor.CollectingMatcher;
import org.apache.lucene.monitor.MatcherFactory;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class QueryMatch {
    private final String queryId;
    public static final MatcherFactory<QueryMatch> SIMPLE_MATCHER = searcher -> new CollectingMatcher<QueryMatch>(searcher, ScoreMode.COMPLETE_NO_SCORES){

        @Override
        public QueryMatch resolve(QueryMatch match1, QueryMatch match2) {
            return match1;
        }

        @Override
        protected QueryMatch doMatch(String queryId, int doc, Scorable scorer) {
            return new QueryMatch(queryId);
        }
    };

    public QueryMatch(String queryId) {
        this.queryId = Objects.requireNonNull(queryId);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryMatch)) {
            return false;
        }
        QueryMatch that = (QueryMatch)o;
        return Objects.equals(this.queryId, that.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.queryId);
    }

    public String toString() {
        return "Match(query=" + this.queryId + ")";
    }
}

