/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api;

import java.io.Serializable;
import java.util.Set;
import org.apache.logging.log4j.catalog.api.Constraint;
import org.apache.logging.log4j.catalog.api.DataType;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = -756109102178482698L;
    private Long id;
    private String name;
    private String displayName;
    private String description;
    private DataType dataType;
    private boolean indexed;
    private boolean sortable;
    private boolean required;
    private boolean requestContext;
    private Set<String> examples;
    private Set<String> aliases;
    private Set<Constraint> constraints;
    private String catalogId = "DEFAULT";

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Attribute setName(String name) {
        this.name = name;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Attribute setDisplayName(String name) {
        this.displayName = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Attribute setDescription(String description) {
        this.description = description;
        return this;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Attribute setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public Attribute setIndexed(boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public Attribute setSortable(boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Attribute setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public boolean isRequestContext() {
        return this.requestContext;
    }

    public Attribute setRequestContext(boolean isRequestContext) {
        this.requestContext = isRequestContext;
        return this;
    }

    public Set<String> getExamples() {
        return this.examples;
    }

    public Attribute setExamples(Set<String> examples) {
        this.examples = examples;
        return this;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Attribute setAliases(Set<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public Attribute setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
        return this;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("id=\"").append(this.id).append("\" ");
        sb.append("catalog id=\"").append(this.catalogId).append("\" ");
        sb.append("name=\"").append(this.name).append("\" ");
        sb.append("displayName=\"").append(this.displayName).append("\" ");
        sb.append("description=\"").append(this.description).append("\" ");
        sb.append("dataType=\"");
        if (this.dataType == null) {
            sb.append("null");
        } else {
            sb.append(this.dataType.getTypeName());
        }
        sb.append("\" ");
        sb.append("indexed=\"").append(this.indexed).append("\" ");
        sb.append("sortable=\"").append(this.sortable).append("\" ");
        sb.append("required=\"").append(this.required).append("\" ");
        sb.append("requestContext=\"").append(this.requestContext).append("\" ");
        if (this.constraints != null) {
            sb.append("constraints[");
            boolean first = true;
            for (Constraint constraint : this.constraints) {
                if (!first) {
                    sb.append(" ");
                }
                sb.append("name=\"").append(constraint.getConstraintType().getName()).append("\"");
                sb.append("value=\"").append(constraint.getValue()).append("\"");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }
}

