/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.LevelInequalityRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.rule.TimestampInequalityRule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class InequalityRule
extends AbstractRule {
    static final long serialVersionUID = -5592986598528885122L;
    private static final LoggingEventFieldResolver RESOLVER = LoggingEventFieldResolver.getInstance();
    private final String field;
    private final String value;
    private final String inequalitySymbol;

    private InequalityRule(String inequalitySymbol, String field, String value) {
        this.inequalitySymbol = inequalitySymbol;
        if (!RESOLVER.isField(field)) {
            throw new IllegalArgumentException("Invalid " + inequalitySymbol + " rule - " + field + " is not a supported field");
        }
        this.field = field;
        this.value = value;
    }

    public static Rule getRule(String inequalitySymbol, Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid " + inequalitySymbol + " rule - expected two parameters but received " + stack.size());
        }
        String p2 = stack.pop().toString();
        String p1 = stack.pop().toString();
        return InequalityRule.getRule(inequalitySymbol, p1, p2);
    }

    public static Rule getRule(String inequalitySymbol, String field, String value) {
        if (field.equalsIgnoreCase("LEVEL")) {
            return LevelInequalityRule.getRule(inequalitySymbol, value);
        }
        if (field.equalsIgnoreCase("TIMESTAMP")) {
            return TimestampInequalityRule.getRule(inequalitySymbol, value);
        }
        return new InequalityRule(inequalitySymbol, field, value);
    }

    public boolean evaluate(LoggingEvent event, Map matches) {
        long first = 0L;
        try {
            first = new Long(RESOLVER.getValue(this.field, event).toString());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        long second = 0L;
        try {
            second = new Long(this.value);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        boolean result = false;
        if ("<".equals(this.inequalitySymbol)) {
            result = first < second;
        } else if (">".equals(this.inequalitySymbol)) {
            result = first > second;
        } else if ("<=".equals(this.inequalitySymbol)) {
            result = first <= second;
        } else if (">=".equals(this.inequalitySymbol)) {
            boolean bl = result = first >= second;
        }
        if (result && matches != null) {
            HashSet<String> entries = (HashSet<String>)matches.get(this.field.toUpperCase());
            if (entries == null) {
                entries = new HashSet<String>();
                matches.put(this.field.toUpperCase(), entries);
            }
            entries.add(String.valueOf(first));
        }
        return result;
    }
}

