/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.operation.OperationManager;
import org.apache.kyuubi.service.CompositeService;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager$;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t]e!B\u001d;\u0003\u0003\u0019\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000ba\u0003A\u0011A-\t\u000fu\u0003\u0001\u0019!C\u0005=\"91\r\u0001a\u0001\n\u0013!\u0007B\u00026\u0001A\u0003&q\fC\u0004p\u0001\u0001\u0007I\u0011\u00039\t\u000fQ\u0004\u0001\u0019!C\tk\"1q\u000f\u0001Q!\nEDQ\u0001\u001f\u0001\u0005\u0002ADQ!\u001f\u0001\u0005\niDqa\u001f\u0001A\u0002\u0013%A\u0010C\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004!9\u0011q\u0001\u0001!B\u0013i\bBBA\u0006\u0001\u0011\u0005A\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!A\u0011\u0011\u0007\u0001!\u0002\u0013\t\t\u0002C\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u00026!A\u0011Q\b\u0001!\u0002\u0013\t9\u0004\u0003\u0004\u0002@\u00011\tB\u0018\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0005C\u0006\u0002L\u0001\u0001\r\u00111A\u0005\n\u00055\u0003bCA)\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002\u0006\u00021\t!a\"\t\u000f\u0005U\u0005A\"\u0005\u0002\u0018\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005-\u0007bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003?\u0004A\u0011BAq\u0011\u001d\t)\u000f\u0001C\u0001\u0003ODq!!<\u0001\t\u0003\ty\u000fC\u0004\u0002t\u0002!)\"!>\t\u000f\u0005m\b\u0001\"\u0001\u0002~\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0001b\u0002B\u000e\u0001\u0011\u0005\u0011Q \u0005\b\u0005;\u0001A\u0011AA\u007f\u0011-\u0011y\u0002\u0001a\u0001\u0002\u0004%IA!\t\t\u0017\t%\u0002\u00011AA\u0002\u0013%!1\u0006\u0005\f\u0005_\u0001\u0001\u0019!A!B\u0013\u0011\u0019\u0003C\u0006\u00032\u0001\u0001\r\u00111A\u0005\n\t\u0005\u0002b\u0003B\u001a\u0001\u0001\u0007\t\u0019!C\u0005\u0005kA1B!\u000f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003$!Y!1\b\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0011\u0011-\u0011i\u0004\u0001a\u0001\u0002\u0004%IAa\u0010\t\u0017\t\r\u0003\u00011A\u0001B\u0003&!1\u0005\u0005\u000b\u0005\u000b\u0002\u0001R1A\u0005\n\t\u0005\u0002B\u0003B$\u0001!\u0015\r\u0011\"\u0003\u0003\"!Q!\u0011\n\u0001\t\u0006\u0004%IA!\t\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!q\f\u0001\u0005\u0002\t\u0005\u0004b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\b\u0005_\u0002A\u0011\u0001B9\u0011\u001d\u0011)\b\u0001C!\u0005oBaA!\"\u0001\t\u0003R\bB\u0002BD\u0001\u0011\u0005#\u0010\u0003\u0004\u0003\n\u0002!IA\u001f\u0005\t\u0005\u0017\u0003A\u0011\u0001\u001f\u0003\u000e\nq1+Z:tS>tW*\u00198bO\u0016\u0014(BA\u001e=\u0003\u001d\u0019Xm]:j_:T!!\u0010 \u0002\r-LX/\u001e2j\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fr\nqa]3sm&\u001cW-\u0003\u0002J\r\n\u00012i\\7q_NLG/Z*feZL7-Z\u0001\u0005]\u0006lW\r\u0005\u0002M+:\u0011Qj\u0015\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\n\u000ba\u0001\u0010:p_Rt$\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b\u0016A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001V)\u0002\rqJg.\u001b;?)\tQF\f\u0005\u0002\\\u00015\t!\bC\u0003K\u0005\u0001\u00071*\u0001\u0005tQV$Hm\\<o+\u0005y\u0006C\u00011b\u001b\u0005\t\u0016B\u00012R\u0005\u001d\u0011un\u001c7fC:\fAb\u001d5vi\u0012|wO\\0%KF$\"!\u001a5\u0011\u0005\u00014\u0017BA4R\u0005\u0011)f.\u001b;\t\u000f%$\u0011\u0011!a\u0001?\u0006\u0019\u0001\u0010J\u0019\u0002\u0013MDW\u000f\u001e3po:\u0004\u0003FA\u0003m!\t\u0001W.\u0003\u0002o#\nAao\u001c7bi&dW-A\t`_B,'/\u0019;j_:dun\u001a*p_R,\u0012!\u001d\t\u0004AJ\\\u0015BA:R\u0005\u0019y\u0005\u000f^5p]\u0006)rl\u001c9fe\u0006$\u0018n\u001c8M_\u001e\u0014vn\u001c;`I\u0015\fHCA3w\u0011\u001dIw!!AA\u0002E\f!cX8qKJ\fG/[8o\u0019><'k\\8uA\u0005\u0001r\u000e]3sCRLwN\u001c'pOJ{w\u000e^\u0001\u0018S:LGo\u00149fe\u0006$\u0018n\u001c8M_\u001e\u0014vn\u001c;ESJ$\u0012!Z\u0001\u0012?2\fG/Z:u\u0019><w.\u001e;US6,W#A?\u0011\u0005\u0001t\u0018BA@R\u0005\u0011auN\\4\u0002+}c\u0017\r^3ti2{wm\\;u)&lWm\u0018\u0013fcR\u0019Q-!\u0002\t\u000f%d\u0011\u0011!a\u0001{\u0006\u0011r\f\\1uKN$Hj\\4pkR$\u0016.\\3!Q\tiA.\u0001\tmCR,7\u000f\u001e'pO>,H\u000fV5nK\u0006y\u0001.\u00198eY\u0016$vnU3tg&|g.\u0006\u0002\u0002\u0012AA\u00111CA\u0011\u0003K\tY#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u00037\ti\"\u0001\u0003vi&d'BAA\u0010\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0012Q\u0003\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcA.\u0002(%\u0019\u0011\u0011\u0006\u001e\u0003\u001bM+7o]5p]\"\u000bg\u000e\u001a7f!\rY\u0016QF\u0005\u0004\u0003_Q$aB*fgNLwN\\\u0001\u0011Q\u0006tG\r\\3U_N+7o]5p]\u0002\na\u0002^5nK>,Ho\u00115fG.,'/\u0006\u0002\u00028A!\u00111CA\u001d\u0013\u0011\tY$!\u0006\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-A\buS6,w.\u001e;DQ\u0016\u001c7.\u001a:!\u0003!I7oU3sm\u0016\u0014\u0018\u0001C3yK\u000e\u0004vn\u001c7\u0016\u0005\u0005\u0015\u0003\u0003BA\n\u0003\u000fJA!!\u0013\u0002\u0016\t\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u00031)\u00070Z2Q_>dw\fJ3r)\r)\u0017q\n\u0005\tSV\t\t\u00111\u0001\u0002F\u0005IQ\r_3d!>|G\u000eI\u0001\u001agV\u0014W.\u001b;CC\u000e\\wM]8v]\u0012|\u0005/\u001a:bi&|g\u000e\u0006\u0003\u0002X\u0005U\u0004\u0007BA-\u0003G\u0002b!a\u0005\u0002\\\u0005}\u0013\u0002BA/\u0003+\u0011aAR;ukJ,\u0007\u0003BA1\u0003Gb\u0001\u0001B\u0006\u0002f]\t\t\u0011!A\u0003\u0002\u0005\u001d$aA0%cE!\u0011\u0011NA8!\r\u0001\u00171N\u0005\u0004\u0003[\n&a\u0002(pi\"Lgn\u001a\t\u0004A\u0006E\u0014bAA:#\n\u0019\u0011I\\=\t\u000f\u0005]t\u00031\u0001\u0002z\u0005\t!\u000f\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\u0011\ty(!\b\u0002\t1\fgnZ\u0005\u0005\u0003\u0007\u000biH\u0001\u0005Sk:t\u0017M\u00197f\u0003Ay\u0007/\u001a:bi&|g.T1oC\u001e,'/\u0006\u0002\u0002\nB!\u00111RAI\u001b\t\tiIC\u0002\u0002\u0010r\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\t\u0005M\u0015Q\u0012\u0002\u0011\u001fB,'/\u0019;j_:l\u0015M\\1hKJ\fQb\u0019:fCR,7+Z:tS>tG\u0003DA\u0016\u00033\u000b\u0019,a.\u0002<\u0006}\u0006bBAN3\u0001\u0007\u0011QT\u0001\taJ|Go\\2pYB!\u0011qTAX\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016A\u0002;ie&4GO\u0003\u0003\u0002(\u0006%\u0016a\u0001:qG*\u0019q)a+\u000b\u0007\u00055f(\u0001\u0003iSZ,\u0017\u0002BAY\u0003C\u0013\u0001\u0003\u0016)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\t\r\u0005U\u0016\u00041\u0001L\u0003\u0011)8/\u001a:\t\r\u0005e\u0016\u00041\u0001L\u0003!\u0001\u0018m]:x_J$\u0007BBA_3\u0001\u00071*A\u0005ja\u0006#GM]3tg\"9\u0011\u0011Y\rA\u0002\u0005\r\u0017\u0001B2p]\u001a\u0004R\u0001TAc\u0017.K1!a2X\u0005\ri\u0015\r]\u0001\f_B,gnU3tg&|g\u000e\u0006\u0007\u0002&\u00055\u0017qZAi\u0003'\f)\u000eC\u0004\u0002\u001cj\u0001\r!!(\t\r\u0005U&\u00041\u0001L\u0011\u0019\tIL\u0007a\u0001\u0017\"1\u0011Q\u0018\u000eA\u0002-Cq!!1\u001b\u0001\u0004\t\u0019-\u0001\u0007dY>\u001cXmU3tg&|g\u000eF\u0002f\u00037Dq!!8\u001c\u0001\u0004\t)#A\u0007tKN\u001c\u0018n\u001c8IC:$G.Z\u0001\u001dI\u0016dW\r^3Pa\u0016\u0014\u0018\r^5p]2{wmU3tg&|g\u000eR5s)\r)\u00171\u001d\u0005\b\u0003;d\u0002\u0019AA\u0013\u0003A9W\r^*fgNLwN\\(qi&|g\u000e\u0006\u0003\u0002j\u0006-\b\u0003\u00021s\u0003WAq!!8\u001e\u0001\u0004\t)#\u0001\u0006hKR\u001cVm]:j_:$B!a\u000b\u0002r\"9\u0011Q\u001c\u0010A\u0002\u0005\u0015\u0012AC:fiN+7o]5p]R)Q-a>\u0002z\"9\u0011Q\\\u0010A\u0002\u0005\u0015\u0002BB\u001e \u0001\u0004\tY#A\nhKR|\u0005/\u001a8TKN\u001c\u0018n\u001c8D_VtG/\u0006\u0002\u0002\u0000B\u0019\u0001M!\u0001\n\u0007\t\r\u0011KA\u0002J]R\f1\"\u00197m'\u0016\u001c8/[8ogR\u0011!\u0011\u0002\t\u0007\u0005\u0017\u0011)\"a\u000b\u000f\t\t5!\u0011\u0003\b\u0004\u001d\n=\u0011\"\u0001*\n\u0007\tM\u0011+A\u0004qC\u000e\\\u0017mZ3\n\t\t]!\u0011\u0004\u0002\t\u0013R,'/\u00192mK*\u0019!1C)\u0002\u001f\u001d,G/\u0012=fGB{w\u000e\\*ju\u0016\fabZ3u\u0003\u000e$\u0018N^3D_VtG/A\t`G>tgMU3tiJL7\r\u001e'jgR,\"Aa\t\u0011\t1\u0013)cS\u0005\u0004\u0005O9&aA*fi\u0006)rlY8oMJ+7\u000f\u001e:jGRd\u0015n\u001d;`I\u0015\fHcA3\u0003.!A\u0011.JA\u0001\u0002\u0004\u0011\u0019#\u0001\n`G>tgMU3tiJL7\r\u001e'jgR\u0004\u0013aD0d_:4\u0017j\u001a8pe\u0016d\u0015n\u001d;\u0002'}\u001bwN\u001c4JO:|'/\u001a'jgR|F%Z9\u0015\u0007\u0015\u00149\u0004\u0003\u0005jQ\u0005\u0005\t\u0019\u0001B\u0012\u0003Ay6m\u001c8g\u0013\u001etwN]3MSN$\b%\u0001\u000b`E\u0006$8\r[\"p]\u001aLuM\\8sK2K7\u000f^\u0001\u0019?\n\fGo\u00195D_:4\u0017j\u001a8pe\u0016d\u0015n\u001d;`I\u0015\fHcA3\u0003B!A\u0011nKA\u0001\u0002\u0004\u0011\u0019#A\u000b`E\u0006$8\r[\"p]\u001aLuM\\8sK2K7\u000f\u001e\u0011\u0002-}\u001bwN\u001c4SKN$(/[2u\u001b\u0006$8\r\u001b'jgR\fAcX2p]\u001aLuM\\8sK6\u000bGo\u00195MSN$\u0018!G0cCR\u001c\u0007nQ8oM&;gn\u001c:f\u001b\u0006$8\r\u001b'jgR\f1B^1mS\u0012\fG/Z&fsR1!q\nB,\u00057\u0002B\u0001\u0019:\u0003RA)\u0001Ma\u0015L\u0017&\u0019!QK)\u0003\rQ+\b\u000f\\33\u0011\u0019\u0011I\u0006\ra\u0001\u0017\u0006\u00191.Z=\t\r\tu\u0003\u00071\u0001L\u0003\u00151\u0018\r\\;f\u0003a1\u0018\r\\5eCR,\u0017I\u001c3O_Jl\u0017\r\\5{K\u000e{gN\u001a\u000b\u0005\u0003\u0007\u0014\u0019\u0007C\u0004\u0003fE\u0002\r!a1\u0002\r\r|gNZ5h\u0003A1\u0018\r\\5eCR,')\u0019;dQ.+\u0017\u0010\u0006\u0004\u0003P\t-$Q\u000e\u0005\u0007\u00053\u0012\u0004\u0019A&\t\r\tu#\u00071\u0001L\u0003E1\u0018\r\\5eCR,')\u0019;dQ\u000e{gN\u001a\u000b\u0005\u0003\u0007\u0014\u0019\bC\u0004\u0003fM\u0002\r!a1\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002f\u0005sBq!!15\u0001\u0004\u0011Y\b\u0005\u0003\u0003~\t\u0005UB\u0001B@\u0015\r\u0011)\u0007P\u0005\u0005\u0005\u0007\u0013yH\u0001\u0006LsV,(-[\"p]\u001a\fQa\u001d;beR\fAa\u001d;pa\u0006\u00192\u000f^1siRKW.Z8vi\u000eCWmY6fe\u000692\u000f^1siR+'/\\5oCRLgnZ\"iK\u000e\\WM\u001d\u000b\u0004K\n=\u0005b\u0002BDq\u0001\u0007!\u0011\u0013\t\u0005A\nMU-C\u0002\u0003\u0016F\u0013\u0011BR;oGRLwN\u001c\u0019")
public abstract class SessionManager
extends CompositeService {
    private Set<String> _confRestrictMatchList;
    private Set<String> _confIgnoreMatchList;
    private Set<String> _batchConfIgnoreMatchList;
    private final String name;
    private volatile boolean org$apache$kyuubi$session$SessionManager$$shutdown;
    private Option<String> _operationLogRoot;
    private volatile long _latestLogoutTime;
    private final ConcurrentHashMap<SessionHandle, Session> org$apache$kyuubi$session$SessionManager$$handleToSession;
    private final ScheduledExecutorService timeoutChecker;
    private ThreadPoolExecutor execPool;
    private Set<String> _confRestrictList;
    private Set<String> _confIgnoreList;
    private Set<String> _batchConfIgnoreList;
    private volatile byte bitmap$0;

    public boolean org$apache$kyuubi$session$SessionManager$$shutdown() {
        return this.org$apache$kyuubi$session$SessionManager$$shutdown;
    }

    private void org$apache$kyuubi$session$SessionManager$$shutdown_$eq(boolean x$1) {
        this.org$apache$kyuubi$session$SessionManager$$shutdown = x$1;
    }

    public Option<String> _operationLogRoot() {
        return this._operationLogRoot;
    }

    public void _operationLogRoot_$eq(Option<String> x$1) {
        this._operationLogRoot = x$1;
    }

    public Option<String> operationLogRoot() {
        return this._operationLogRoot();
    }

    private void initOperationLogRootDir() {
        try {
            String logRoot = this.isServer() ? this.conf().get(KyuubiConf$.MODULE$.SERVER_OPERATION_LOG_DIR_ROOT()) : this.conf().get(KyuubiConf$.MODULE$.ENGINE_OPERATION_LOG_DIR_ROOT());
            Path logPath = Files.createDirectories(Utils$.MODULE$.getAbsolutePathFromWork(logRoot, Utils$.MODULE$.getAbsolutePathFromWork$default$2()), new FileAttribute[0]);
            this._operationLogRoot_$eq((Option<String>)new Some((Object)((Object)logPath).toString()));
        }
        catch (IOException e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Failed to initialize operation log root directory: ").append(this._operationLogRoot()).toString(), e);
            this._operationLogRoot_$eq((Option<String>)None$.MODULE$);
        }
    }

    private long _latestLogoutTime() {
        return this._latestLogoutTime;
    }

    private void _latestLogoutTime_$eq(long x$1) {
        this._latestLogoutTime = x$1;
    }

    public long latestLogoutTime() {
        return this._latestLogoutTime();
    }

    public ConcurrentHashMap<SessionHandle, Session> org$apache$kyuubi$session$SessionManager$$handleToSession() {
        return this.org$apache$kyuubi$session$SessionManager$$handleToSession;
    }

    private ScheduledExecutorService timeoutChecker() {
        return this.timeoutChecker;
    }

    public abstract boolean isServer();

    private ThreadPoolExecutor execPool() {
        return this.execPool;
    }

    private void execPool_$eq(ThreadPoolExecutor x$1) {
        this.execPool = x$1;
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.execPool().submit(r);
    }

    public abstract OperationManager operationManager();

    public abstract Session createSession(TProtocolVersion var1, String var2, String var3, String var4, Map<String, String> var5);

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Opening session for ").append(user).append("@").append(ipAddress).toString());
        Session session = this.createSession(protocol, user, password, ipAddress, conf);
        try {
            SessionHandle handle = session.handle();
            session.open();
            this.setSession(handle, session);
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append(user).append("'s session with ").append(handle).append(session.name().map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("/").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" is opened,").append(" current opening sessions ").append(this.getOpenSessionCount()).toString());
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                session.close();
            }
            catch (Throwable t) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error closing session for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            throw KyuubiSQLException$.MODULE$.apply(e);
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        this._latestLogoutTime_$eq(System.currentTimeMillis());
        Session session = this.org$apache$kyuubi$session$SessionManager$$handleToSession().remove(sessionHandle);
        if (session == null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append(sessionHandle).append(session.name().map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(1).append("/").append((String)x$2).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" is closed,").append(" current opening sessions ").append(this.getOpenSessionCount()).toString());
        try {
            session.close();
        }
        finally {
            this.deleteOperationLogSessionDir(sessionHandle);
        }
    }

    private void deleteOperationLogSessionDir(SessionHandle sessionHandle) {
        this._operationLogRoot().foreach((Function1 & Serializable & scala.Serializable)logRoot -> {
            Boolean bl;
            Path rootPath = Paths.get(logRoot, sessionHandle.identifier().toString());
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.deleteDirectoryRecursively(rootPath.toFile()));
            }
            catch (IOException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Failed to delete session operation log directory ").append(((Object)rootPath).toString()).toString(), e);
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
    }

    public Option<Session> getSessionOption(SessionHandle sessionHandle) {
        return Option$.MODULE$.apply((Object)this.org$apache$kyuubi$session$SessionManager$$handleToSession().get(sessionHandle));
    }

    public Session getSession(SessionHandle sessionHandle) {
        return (Session)this.getSessionOption(sessionHandle).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    public final void setSession(SessionHandle sessionHandle, Session session) {
        this.org$apache$kyuubi$session$SessionManager$$handleToSession().put(sessionHandle, session);
    }

    public int getOpenSessionCount() {
        return this.org$apache$kyuubi$session$SessionManager$$handleToSession().size();
    }

    public Iterable<Session> allSessions() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala();
    }

    public int getExecPoolSize() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getPoolSize();
    }

    public int getActiveCount() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getActiveCount();
    }

    private Set<String> _confRestrictList() {
        return this._confRestrictList;
    }

    private void _confRestrictList_$eq(Set<String> x$1) {
        this._confRestrictList = x$1;
    }

    private Set<String> _confIgnoreList() {
        return this._confIgnoreList;
    }

    private void _confIgnoreList_$eq(Set<String> x$1) {
        this._confIgnoreList = x$1;
    }

    private Set<String> _batchConfIgnoreList() {
        return this._batchConfIgnoreList;
    }

    private void _batchConfIgnoreList_$eq(Set<String> x$1) {
        this._batchConfIgnoreList = x$1;
    }

    private Set<String> _confRestrictMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._confRestrictMatchList = (Set)((SetLike)this._confRestrictList().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$4 -> new StringOps(Predef$.MODULE$.augmentString(x$4)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._confRestrictMatchList;
    }

    private Set<String> _confRestrictMatchList() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._confRestrictMatchList$lzycompute() : this._confRestrictMatchList;
    }

    private Set<String> _confIgnoreMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._confIgnoreMatchList = (Set)((SetLike)this._confIgnoreList().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$6 -> new StringOps(Predef$.MODULE$.augmentString(x$6)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._confIgnoreMatchList;
    }

    private Set<String> _confIgnoreMatchList() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this._confIgnoreMatchList$lzycompute() : this._confIgnoreMatchList;
    }

    private Set<String> _batchConfIgnoreMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this._batchConfIgnoreMatchList = (Set)((SetLike)this._batchConfIgnoreList().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$8 -> new StringOps(Predef$.MODULE$.augmentString(x$8)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this._batchConfIgnoreMatchList;
    }

    private Set<String> _batchConfIgnoreMatchList() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this._batchConfIgnoreMatchList$lzycompute() : this._batchConfIgnoreMatchList;
    }

    public Option<Tuple2<String, String>> validateKey(String key, String value) {
        None$ none$;
        String normalizedKey;
        String string;
        if (key.startsWith(package$.MODULE$.SET_PREFIX())) {
            String newKey = key.substring(package$.MODULE$.SET_PREFIX().length());
            if (newKey.startsWith(package$.MODULE$.ENV_PREFIX())) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append(key).append(" is forbidden, env:* variables can not be set.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            string = newKey.startsWith(package$.MODULE$.SYSTEM_PREFIX()) ? newKey.substring(package$.MODULE$.SYSTEM_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.HIVECONF_PREFIX()) ? newKey.substring(package$.MODULE$.HIVECONF_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.HIVEVAR_PREFIX()) ? newKey.substring(package$.MODULE$.HIVEVAR_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.METACONF_PREFIX()) ? newKey.substring(package$.MODULE$.METACONF_PREFIX().length()) : newKey)));
        } else {
            string = normalizedKey = key;
        }
        if (this._confRestrictMatchList().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)normalizedKey.startsWith(x$9))) || this._confRestrictList().contains((Object)normalizedKey)) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(112).append(normalizedKey).append(" is a restrict key according to the server-side").append(" configuration, please remove it and retry if you want to proceed").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        if (this._confIgnoreMatchList().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)normalizedKey.startsWith(x$10))) || this._confIgnoreList().contains((Object)normalizedKey)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append(normalizedKey).append(" is a ignored key according to the server-side configuration").toString());
            none$ = None$.MODULE$;
        } else {
            none$ = new Some((Object)new Tuple2((Object)normalizedKey, (Object)value));
        }
        return none$;
    }

    public Map<String, String> validateAndNormalizeConf(Map<String, String> config) {
        return (Map)config.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(this.validateKey(k, v));
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
    }

    public Option<Tuple2<String, String>> validateBatchKey(String key, String value) {
        None$ none$;
        if (this._batchConfIgnoreMatchList().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)key.startsWith(x$11))) || this._batchConfIgnoreList().contains((Object)key)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append(key).append(" is a ignored batch key according to the server-side configuration").toString());
            none$ = None$.MODULE$;
        } else {
            none$ = new Some((Object)new Tuple2((Object)key, (Object)value));
        }
        return none$;
    }

    public Map<String, String> validateBatchConf(Map<String, String> config) {
        return (Map)config.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(this.validateBatchKey(k, v));
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService(this.operationManager());
        this.initOperationLogRootDir();
        int poolSize = this.isServer() ? BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_POOL_SIZE())) : BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_POOL_SIZE()));
        int waitQueueSize = this.isServer() ? BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_WAIT_QUEUE_SIZE())) : BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_WAIT_QUEUE_SIZE()));
        long keepAliveMs = this.isServer() ? BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_KEEPALIVE_TIME())) : BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_KEEPALIVE_TIME()));
        this._confRestrictList_$eq((Set<String>)((TraversableOnce)conf.get(KyuubiConf$.MODULE$.SESSION_CONF_RESTRICT_LIST())).toSet());
        this._confIgnoreList_$eq((Set<String>)((TraversableOnce)conf.get(KyuubiConf$.MODULE$.SESSION_CONF_IGNORE_LIST())).toSet());
        this._batchConfIgnoreList_$eq((Set<String>)((TraversableOnce)conf.get(KyuubiConf$.MODULE$.BATCH_CONF_IGNORE_LIST())).toSet());
        this.execPool_$eq(ThreadUtils$.MODULE$.newDaemonQueuedThreadPool(poolSize, waitQueueSize, keepAliveMs, new StringBuilder(10).append(this.name).append("-exec-pool").toString()));
        super.initialize(conf);
    }

    @Override
    public synchronized void start() {
        this.startTimeoutChecker();
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.org$apache$kyuubi$session$SessionManager$$shutdown_$eq(true);
        long shutdownTimeout = this.isServer() ? BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_EXEC_POOL_SHUTDOWN_TIMEOUT())) : BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT()));
        ThreadUtils$.MODULE$.shutdown(this.timeoutChecker(), (Duration)Duration$.MODULE$.apply(shutdownTimeout, TimeUnit.MILLISECONDS));
        ThreadUtils$.MODULE$.shutdown(this.execPool(), (Duration)Duration$.MODULE$.apply(shutdownTimeout, TimeUnit.MILLISECONDS));
    }

    private void startTimeoutChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.SESSION_CHECK_INTERVAL()));
        long timeout = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.SESSION_IDLE_TIMEOUT()));
        Runnable checkTask = new Runnable(this, timeout){
            private final /* synthetic */ SessionManager $outer;
            private final long timeout$1;

            public void run() {
                block0: {
                    long current = System.currentTimeMillis();
                    if (this.$outer.org$apache$kyuubi$session$SessionManager$$shutdown()) break block0;
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)session -> {
                        $anon$1.$anonfun$run$1(this, current, session);
                        return BoxedUnit.UNIT;
                    });
                }
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, long current$1, Session session) {
                if (session.lastAccessTime() + $this.timeout$1 <= current$1 && session.getNoOperationTime() > $this.timeout$1) {
                    try {
                        $this.$outer.closeSession(session.handle());
                    }
                    catch (KyuubiSQLException e) {
                        $this.$outer.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error closing idle session ").append(session.handle()).toString(), e);
                    }
                } else {
                    session.closeExpiredOperations();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timeout$1 = timeout$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.session.SessionManager$$anon$1 long org.apache.kyuubi.session.Session ), $anonfun$run$2(org.apache.kyuubi.session.Session )}, serializedLambda);
            }
        };
        this.timeoutChecker().scheduleWithFixedDelay(checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    public void startTerminatingChecker(Function0<BoxedUnit> stop) {
        block1: {
            if (this.isServer()) break block1;
            this._latestLogoutTime_$eq(System.currentTimeMillis());
            long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_CHECK_INTERVAL()));
            long idleTimeout = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_IDLE_TIMEOUT()));
            if (idleTimeout > 0L) {
                Runnable checkTask = new Runnable(this, idleTimeout, stop){
                    private final /* synthetic */ SessionManager $outer;
                    private final long idleTimeout$1;
                    private final Function0 stop$1;

                    public void run() {
                        block0: {
                            if (this.$outer.org$apache$kyuubi$session$SessionManager$$shutdown() || System.currentTimeMillis() - this.$outer.latestLogoutTime() <= this.idleTimeout$1 || this.$outer.getOpenSessionCount() > 0) break block0;
                            this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Idled for more than ").append($this.idleTimeout$1).append(" ms, terminating").toString());
                            this.stop$1.apply$mcV$sp();
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.idleTimeout$1 = idleTimeout$1;
                        this.stop$1 = stop$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(org.apache.kyuubi.session.SessionManager$$anon$2 )}, serializedLambda);
                    }
                };
                this.timeoutChecker().scheduleWithFixedDelay(checkTask, interval, interval, TimeUnit.MILLISECONDS);
            }
        }
    }

    public SessionManager(String name) {
        this.name = name;
        super(name);
        this.org$apache$kyuubi$session$SessionManager$$shutdown = false;
        this._operationLogRoot = None$.MODULE$;
        this._latestLogoutTime = System.currentTimeMillis();
        this.org$apache$kyuubi$session$SessionManager$$handleToSession = new ConcurrentHashMap();
        this.timeoutChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(16).append(name).append("-timeout-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
    }
}

