/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.UserIpAddress;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00154A\u0001D\u0007\u0001-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003#\u0011!1\u0003A!A!\u0002\u0013\u0011\u0003\"B\u0014\u0001\t\u0003A\u0003bB\u0017\u0001\u0005\u0004%IA\f\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\u0018\t\r-\u0003A\u0011A\u0007M\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0005I\u0019Vm]:j_:d\u0015.\\5uKJLU\u000e\u001d7\u000b\u00059y\u0011aB:fgNLwN\u001c\u0006\u0003!E\taa[=vk\nL'B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005i\u0011B\u0001\u0011\u000e\u00059\u0019Vm]:j_:d\u0015.\\5uKJ\f\u0011\"^:fe2KW.\u001b;\u0011\u0005a\u0019\u0013B\u0001\u0013\u001a\u0005\rIe\u000e^\u0001\u000fSB\fE\r\u001a:fgNd\u0015.\\5u\u0003I)8/\u001a:Ja\u0006#GM]3tg2KW.\u001b;\u0002\rqJg.\u001b;?)\u0011I#f\u000b\u0017\u0011\u0005y\u0001\u0001\"B\u0011\u0005\u0001\u0004\u0011\u0003\"B\u0013\u0005\u0001\u0004\u0011\u0003\"\u0002\u0014\u0005\u0001\u0004\u0011\u0013!C0d_VtG/\u001a:t+\u0005y\u0003\u0003\u0002\u00196o\tk\u0011!\r\u0006\u0003eM\nA!\u001e;jY*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005\ri\u0015\r\u001d\t\u0003q}r!!O\u001f\u0011\u0005iJR\"A\u001e\u000b\u0005q*\u0012A\u0002\u001fs_>$h(\u0003\u0002?3\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tq\u0014\u0004\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u00061\u0011\r^8nS\u000eT!aR\u0019\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002J\t\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\f!bX2pk:$XM]:!\u0003!\u0019w.\u001e8uKJ\u001cH#A\u0018\u0002\u0013%t7M]3nK:$HCA(S!\tA\u0002+\u0003\u0002R3\t!QK\\5u\u0011\u0015\u0019\u0006\u00021\u0001U\u00035)8/\u001a:Ja\u0006#GM]3tgB\u0011a$V\u0005\u0003-6\u0011Q\"V:fe&\u0003\u0018\t\u001a3sKN\u001c\u0018!\u00033fGJ,W.\u001a8u)\ty\u0015\fC\u0003T\u0013\u0001\u0007A+\u0001\bj]\u000e\u0014H*[7ji\u000e{WO\u001c;\u0015\t=cf\f\u0019\u0005\u0006;*\u0001\raN\u0001\u0004W\u0016L\b\"B0\u000b\u0001\u0004\u0011\u0013!\u00027j[&$\b\"B1\u000b\u0001\u00049\u0014\u0001C3se>\u0014Xj]4\u0002\u001d\u0011,7M\u001d'j[&$8i\\;oiR\u0011q\n\u001a\u0005\u0006;.\u0001\ra\u000e")
public class SessionLimiterImpl
implements SessionLimiter {
    private final int userLimit;
    private final int ipAddressLimit;
    private final int userIpAddressLimit;
    private final Map<String, AtomicInteger> _counters;

    private Map<String, AtomicInteger> _counters() {
        return this._counters;
    }

    public Map<String, AtomicInteger> counters() {
        return this._counters();
    }

    @Override
    public void increment(UserIpAddress userIpAddress) {
        block2: {
            String user = userIpAddress.user();
            String ipAddress = userIpAddress.ipAddress();
            if (this.userIpAddressLimit > 0 && StringUtils.isNotBlank((CharSequence)user) && StringUtils.isNotBlank((CharSequence)ipAddress)) {
                this.incrLimitCount(new StringBuilder(1).append(user).append(":").append(ipAddress).toString(), this.userIpAddressLimit, new StringBuilder(71).append("Connection limit per user:ipaddress reached").append(" (user:ipaddress: ").append(user).append(":").append(ipAddress).append(" limit: ").append(this.userIpAddressLimit).append(")").toString());
            }
            if (this.userLimit > 0 && StringUtils.isNotBlank((CharSequence)user)) {
                this.incrLimitCount(user, this.userLimit, new StringBuilder(50).append("Connection limit per user reached (user: ").append(user).append(" limit: ").append(this.userLimit).append(")").toString());
            }
            if (this.ipAddressLimit <= 0 || !StringUtils.isNotBlank((CharSequence)ipAddress)) break block2;
            this.incrLimitCount(ipAddress, this.ipAddressLimit, new StringBuilder(60).append("Connection limit per ipaddress reached (ipaddress: ").append(ipAddress).append(" limit: ").append(this.ipAddressLimit).append(")").toString());
        }
    }

    @Override
    public void decrement(UserIpAddress userIpAddress) {
        block2: {
            String user = userIpAddress.user();
            String ipAddress = userIpAddress.ipAddress();
            if (this.userLimit > 0 && StringUtils.isNotBlank((CharSequence)user)) {
                this.decrLimitCount(user);
            }
            if (this.ipAddressLimit > 0 && StringUtils.isNotBlank((CharSequence)ipAddress)) {
                this.decrLimitCount(ipAddress);
            }
            if (this.userIpAddressLimit <= 0 || !StringUtils.isNotBlank((CharSequence)user) || !StringUtils.isNotBlank((CharSequence)ipAddress)) break block2;
            this.decrLimitCount(new StringBuilder(1).append(user).append(":").append(ipAddress).toString());
        }
    }

    private void incrLimitCount(String key, int limit, String errorMsg) {
        AtomicInteger count = this._counters().computeIfAbsent(key, x$1 -> new AtomicInteger());
        if (count.incrementAndGet() > limit) {
            count.decrementAndGet();
            throw KyuubiSQLException$.MODULE$.apply(errorMsg, KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
    }

    private void decrLimitCount(String key) {
        AtomicInteger atomicInteger = this._counters().get(key);
        if (atomicInteger != null) {
            AtomicInteger atomicInteger2 = atomicInteger;
            atomicInteger2.decrementAndGet();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public SessionLimiterImpl(int userLimit, int ipAddressLimit, int userIpAddressLimit) {
        this.userLimit = userLimit;
        this.ipAddressLimit = ipAddressLimit;
        this.userIpAddressLimit = userIpAddressLimit;
        this._counters = new ConcurrentHashMap<String, AtomicInteger>();
    }
}

