/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.thrift.server;

import org.apache.kyuubi.shade.org.apache.thrift.TProcessor;
import org.apache.kyuubi.shade.org.apache.thrift.TProcessorFactory;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocolFactory;
import org.apache.kyuubi.shade.org.apache.thrift.server.TServerEventHandler;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TServerTransport;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TTransportFactory;

public abstract class TServer {
    protected TProcessorFactory processorFactory_;
    protected TServerTransport serverTransport_;
    protected TTransportFactory inputTransportFactory_;
    protected TTransportFactory outputTransportFactory_;
    protected TProtocolFactory inputProtocolFactory_;
    protected TProtocolFactory outputProtocolFactory_;
    private boolean isServing;
    protected TServerEventHandler eventHandler_;
    protected volatile boolean stopped_ = false;

    protected TServer(AbstractServerArgs args) {
        this.processorFactory_ = args.processorFactory;
        this.serverTransport_ = args.serverTransport;
        this.inputTransportFactory_ = args.inputTransportFactory;
        this.outputTransportFactory_ = args.outputTransportFactory;
        this.inputProtocolFactory_ = args.inputProtocolFactory;
        this.outputProtocolFactory_ = args.outputProtocolFactory;
    }

    public abstract void serve();

    public void stop() {
    }

    public boolean isServing() {
        return this.isServing;
    }

    protected void setServing(boolean serving) {
        this.isServing = serving;
    }

    public void setServerEventHandler(TServerEventHandler eventHandler) {
        this.eventHandler_ = eventHandler;
    }

    public TServerEventHandler getEventHandler() {
        return this.eventHandler_;
    }

    public boolean getShouldStop() {
        return this.stopped_;
    }

    public void setShouldStop(boolean shouldStop) {
        this.stopped_ = shouldStop;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractServerArgs<T extends AbstractServerArgs<T>> {
        final TServerTransport serverTransport;
        TProcessorFactory processorFactory;
        TTransportFactory inputTransportFactory = new TTransportFactory();
        TTransportFactory outputTransportFactory = new TTransportFactory();
        TProtocolFactory inputProtocolFactory = new TBinaryProtocol.Factory();
        TProtocolFactory outputProtocolFactory = new TBinaryProtocol.Factory();

        public AbstractServerArgs(TServerTransport transport) {
            this.serverTransport = transport;
        }

        public T processorFactory(TProcessorFactory factory) {
            this.processorFactory = factory;
            return (T)this;
        }

        public T processor(TProcessor processor) {
            this.processorFactory = new TProcessorFactory(processor);
            return (T)this;
        }

        public T transportFactory(TTransportFactory factory) {
            this.inputTransportFactory = factory;
            this.outputTransportFactory = factory;
            return (T)this;
        }

        public T inputTransportFactory(TTransportFactory factory) {
            this.inputTransportFactory = factory;
            return (T)this;
        }

        public T outputTransportFactory(TTransportFactory factory) {
            this.outputTransportFactory = factory;
            return (T)this;
        }

        public T protocolFactory(TProtocolFactory factory) {
            this.inputProtocolFactory = factory;
            this.outputProtocolFactory = factory;
            return (T)this;
        }

        public T inputProtocolFactory(TProtocolFactory factory) {
            this.inputProtocolFactory = factory;
            return (T)this;
        }

        public T outputProtocolFactory(TProtocolFactory factory) {
            this.outputProtocolFactory = factory;
            return (T)this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Args
    extends AbstractServerArgs<Args> {
        public Args(TServerTransport transport) {
            super(transport);
        }
    }
}

