/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net;

import java.util.Objects;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.DataObject;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonObject;
import org.apache.kyuubi.shade.io.vertx.core.net.ProxyOptionsConverter;
import org.apache.kyuubi.shade.io.vertx.core.net.ProxyType;

@DataObject(generateConverter=true, publicConverter=false)
public class ProxyOptions {
    public static final ProxyType DEFAULT_TYPE = ProxyType.HTTP;
    public static final int DEFAULT_PORT = 3128;
    public static final String DEFAULT_HOST = "localhost";
    private String host;
    private int port;
    private String username;
    private String password;
    private ProxyType type;

    public ProxyOptions() {
        this.host = DEFAULT_HOST;
        this.port = 3128;
        this.type = DEFAULT_TYPE;
    }

    public ProxyOptions(ProxyOptions other) {
        this.host = other.getHost();
        this.port = other.getPort();
        this.username = other.getUsername();
        this.password = other.getPassword();
        this.type = other.getType();
    }

    public ProxyOptions(JsonObject json) {
        this();
        ProxyOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ProxyOptionsConverter.toJson(this, json);
        return json;
    }

    public String getHost() {
        return this.host;
    }

    public ProxyOptions setHost(String host) {
        Objects.requireNonNull(host, "Proxy host may not be null");
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ProxyOptions setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid proxy port " + port);
        }
        this.port = port;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public ProxyOptions setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ProxyOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public ProxyType getType() {
        return this.type;
    }

    public ProxyOptions setType(ProxyType type) {
        Objects.requireNonNull(type, "Proxy type may not be null");
        this.type = type;
        return this;
    }
}

