/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.operation;

import java.io.Serializable;
import org.apache.kyuubi.engine.spark.operation.SparkOperation;
import org.apache.kyuubi.operation.IterableFetchIterator;
import org.apache.kyuubi.session.Session;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113A!\u0003\u0006\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011!\u0001\u0004A!A!\u0002\u0013\u0019\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u000bI\u0002A\u0011A\u001a\t\u000be\u0002A\u0011\t\u001e\t\u000bm\u0002A\u0011\u000b\u001f\t\u000b\u0019\u0003A\u0011K$\u0003\u0019\u001d+GOR;oGRLwN\\:\u000b\u0005-a\u0011!C8qKJ\fG/[8o\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051QM\\4j]\u0016T!!\u0005\n\u0002\r-LX/\u001e2j\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ii\u0011AC\u0005\u00037)\u0011ab\u00159be.|\u0005/\u001a:bi&|g.A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005y\u0001S\"A\u0010\u000b\u0005q\u0001\u0012BA\u0011 \u0005\u001d\u0019Vm]:j_:\f1bY1uC2|wMT1nKB\u0011A%\f\b\u0003K-\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\f\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051J\u0013AC:dQ\u0016l\u0017MT1nK\u0006aa-\u001e8di&|gNT1nK\u00061A(\u001b8jiz\"R\u0001N\u001b7oa\u0002\"!\u0007\u0001\t\u000bq)\u0001\u0019A\u000f\t\u000b\t*\u0001\u0019A\u0012\t\u000bA*\u0001\u0019A\u0012\t\u000bE*\u0001\u0019A\u0012\u0002\u0013M$\u0018\r^3nK:$X#A\u0012\u0002\u0019I,7/\u001e7u'\u000eDW-\\1\u0016\u0003u\u0002\"A\u0010#\u000e\u0003}R!\u0001Q!\u0002\u000bQL\b/Z:\u000b\u0005\t\u001b\u0015aA:rY*\u0011QBE\u0005\u0003\u000b~\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003-\u0011XO\\%oi\u0016\u0014h.\u00197\u0015\u0003!\u0003\"!\u0013&\u000e\u0003%J!aS\u0015\u0003\tUs\u0017\u000e\u001e")
public class GetFunctions
extends SparkOperation {
    private final String catalogName;
    private final String schemaName;
    private final String functionName;

    @Override
    public String statement() {
        return new StringBuilder(48).append(super.statement()).append(" [catalog: ").append(this.catalogName).append(",").append(" schemaPattern: ").append(this.schemaName).append(",").append(" functionPattern: ").append(this.functionName).append("]").toString();
    }

    @Override
    public StructType resultSchema() {
        return new StructType().add("FUNCTION_CAT", "string", true, "Function catalog (may be null)").add("FUNCTION_SCHEM", "string", true, "Function schema (may be null)").add("FUNCTION_NAME", "string", true, "Function name. This is the name used to invoke the function").add("REMARKS", "string", true, "Explanatory comment on the function").add("FUNCTION_TYPE", "int", true, "Kind of function.").add("SPECIFIC_NAME", "string", true, "The name which uniquely identifies this function within its schema");
    }

    @Override
    public void runInternal() {
        try {
            String schemaPattern = this.toJavaRegex(this.schemaName);
            String functionPattern = this.toJavaRegex(this.functionName);
            SessionCatalog catalog = this.spark().sessionState().catalog();
            Seq a = (Seq)catalog.listDatabases(schemaPattern).flatMap((Function1 & Serializable & scala.Serializable)db -> (Seq)catalog.listFunctions(db, functionPattern).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                FunctionIdentifier f = (FunctionIdentifier)tuple2._1();
                ExpressionInfo info = catalog.lookupFunctionInfo(f);
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"", info.getDb(), info.getName(), new StringBuilder(23).append("Usage: ").append(info.getUsage()).append("\nExtended Usage:").append(info.getExtended()).toString(), BoxesRunTime.boxToInteger((int)0), info.getClassName()}));
                return row;
            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            this.iter_$eq(new IterableFetchIterator<Row>((Iterable<Row>)a.toList()));
        }
        catch (Throwable x$1) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                catchExpr$1.apply((Object)x$1);
            }
            throw x$1;
        }
    }

    public GetFunctions(Session session, String catalogName, String schemaName, String functionName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.functionName = functionName;
        super(session);
    }
}

