/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.options;

import org.apache.kyuubi.shade.com.google.common.base.Preconditions;

public final class PutOption {
    public static final PutOption DEFAULT = PutOption.newBuilder().build();
    private final long leaseId;
    private final boolean prevKV;

    public static Builder newBuilder() {
        return new Builder();
    }

    private PutOption(long leaseId, boolean prevKV) {
        this.leaseId = leaseId;
        this.prevKV = prevKV;
    }

    public long getLeaseId() {
        return this.leaseId;
    }

    public boolean getPrevKV() {
        return this.prevKV;
    }

    public static class Builder {
        private long leaseId = 0L;
        private boolean prevKV = false;

        private Builder() {
        }

        public Builder withLeaseId(long leaseId) {
            Preconditions.checkArgument(leaseId >= 0L, "leaseId should greater than or equal to zero: leaseId=%s", leaseId);
            this.leaseId = leaseId;
            return this;
        }

        public Builder withPrevKV() {
            this.prevKV = true;
            return this;
        }

        public PutOption build() {
            return new PutOption(this.leaseId, this.prevKV);
        }
    }
}

