/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.options;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.options.OptionsUtil;
import java.util.Optional;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;

public final class DeleteOption {
    public static final DeleteOption DEFAULT = DeleteOption.newBuilder().build();
    private final Optional<ByteSequence> endKey;
    private final boolean prevKV;
    private final boolean prefix;

    public static Builder newBuilder() {
        return new Builder();
    }

    private DeleteOption(Optional<ByteSequence> endKey, boolean prevKV, boolean prefix) {
        this.endKey = endKey;
        this.prevKV = prevKV;
        this.prefix = prefix;
    }

    public Optional<ByteSequence> getEndKey() {
        return this.endKey;
    }

    public boolean isPrevKV() {
        return this.prevKV;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public static class Builder {
        private Optional<ByteSequence> endKey = Optional.empty();
        private boolean prevKV = false;
        private boolean prefix = false;

        private Builder() {
        }

        public Builder withRange(ByteSequence endKey) {
            this.endKey = Optional.ofNullable(endKey);
            return this;
        }

        public Builder isPrefix(boolean prefix) {
            this.prefix = prefix;
            return this;
        }

        @Deprecated
        public Builder withPrefix(ByteSequence prefix) {
            Preconditions.checkNotNull(prefix, "prefix should not be null");
            ByteSequence prefixEnd = OptionsUtil.prefixEndOf(prefix);
            this.withRange(prefixEnd);
            return this;
        }

        public Builder withPrevKV(boolean prevKV) {
            this.prevKV = prevKV;
            return this;
        }

        public DeleteOption build() {
            return new DeleteOption(this.endKey, this.prevKV, this.prefix);
        }
    }
}

