/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.DefaultCLI;
import org.apache.flink.client.cli.GenericCLI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliOptions;
import org.apache.flink.table.client.gateway.context.DefaultContext;
import org.apache.flink.util.JarUtils;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.flink.FlinkEngineUtils$;
import org.apache.kyuubi.engine.flink.FlinkSQLEngine;
import org.apache.kyuubi.util.SignalRegister$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class FlinkSQLEngine$
implements Logging,
scala.Serializable {
    public static FlinkSQLEngine$ MODULE$;
    private final KyuubiConf kyuubiConf;
    private Option<FlinkSQLEngine> currentEngine;
    private final String user;
    private final CountDownLatch org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new FlinkSQLEngine$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    public Option<FlinkSQLEngine> currentEngine() {
        return this.currentEngine;
    }

    public void currentEngine_$eq(Option<FlinkSQLEngine> x$1) {
        this.currentEngine = x$1;
    }

    private String user() {
        return this.user;
    }

    public CountDownLatch org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch() {
        return this.org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch;
    }

    public void main(String[] args) {
        SignalRegister$.MODULE$.registerLogger(this.logger());
        FlinkEngineUtils$.MODULE$.checkFlinkVersion();
        try {
            String executionTarget;
            String flinkConfDir = CliFrontend.getConfigurationDirectoryFromEnv();
            Configuration flinkConf = GlobalConfiguration.loadConfiguration((String)flinkConfDir);
            String string = executionTarget = flinkConf.getString(DeploymentOptions.TARGET);
            boolean bl = "yarn-per-job".equals(string) ? true : "yarn-application".equals(string);
            if (bl) {
                BoxedUnit boxedUnit;
                if (!flinkConf.containsKey("yarn.application.name")) {
                    String appName = new StringBuilder(14).append("kyuubi_").append(this.user()).append("_flink_").append(Instant.now()).toString();
                    flinkConf.setString("yarn.application.name", appName);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if ("kubernetes-application".equals(string)) {
                BoxedUnit boxedUnit;
                if (!flinkConf.containsKey("kubernetes.cluster-id")) {
                    String appName = new StringBuilder(14).append("kyuubi-").append(this.user()).append("-flink-").append(Instant.now()).toString();
                    flinkConf.setString("kubernetes.cluster-id", appName);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Skip generating app name for execution target ").append(string).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            CliOptions cliOptions = FlinkEngineUtils$.MODULE$.parseCliOptions(args);
            List jars = cliOptions.getJars() != null ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(cliOptions.getJars()).asScala() : List$.MODULE$.empty();
            List libDirs = cliOptions.getLibraryDirs() != null ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(cliOptions.getLibraryDirs()).asScala() : List$.MODULE$.empty();
            List<URL> dependencies = this.discoverDependencies((Seq<URL>)jars, (Seq<URL>)libDirs);
            DefaultContext engineContext = new DefaultContext((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(dependencies).asJava(), flinkConf, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new GenericCLI(flinkConf, flinkConfDir), (List)new .colon.colon((Object)new DefaultCLI(), (List)Nil$.MODULE$))).asJava());
            this.kyuubiConf().setIfMissing(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_PORT(), BoxesRunTime.boxToInteger((int)0));
            this.startEngine(engineContext);
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "started engine...");
            this.org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch().await();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                if (this.currentEngine().isDefined()) {
                    this.currentEngine().foreach((Function1 & Serializable & scala.Serializable)engine -> {
                        FlinkSQLEngine$.$anonfun$main$3(throwable3, engine);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            if (throwable2 != null) {
                Throwable throwable4 = throwable2;
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Create FlinkSQL Engine Failed", throwable4);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void startEngine(DefaultContext engineContext) {
        this.currentEngine_$eq((Option<FlinkSQLEngine>)new Some((Object)new FlinkSQLEngine(engineContext)));
        this.currentEngine().foreach((Function1 & Serializable & scala.Serializable)engine -> {
            FlinkSQLEngine$.$anonfun$startEngine$1(engine);
            return BoxedUnit.UNIT;
        });
    }

    private List<URL> discoverDependencies(Seq<URL> jars, Seq<URL> libraries) {
        List list;
        try {
            ObjectRef dependencies = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
            jars.foreach((Function1 & Serializable & scala.Serializable)url -> {
                FlinkSQLEngine$.$anonfun$discoverDependencies$1(dependencies, url);
                return BoxedUnit.UNIT;
            });
            libraries.foreach((Function1 & Serializable & scala.Serializable)libUrl -> {
                FlinkSQLEngine$.$anonfun$discoverDependencies$2(dependencies, libUrl);
                return BoxedUnit.UNIT;
            });
            list = ((ListBuffer)dependencies.elem).toList();
        }
        catch (Exception e) {
            throw KyuubiSQLException$.MODULE$.apply("Could not load all required JAR files.", e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return list;
    }

    public FlinkSQLEngine apply(DefaultContext engineContext) {
        return new FlinkSQLEngine(engineContext);
    }

    public Option<DefaultContext> unapply(FlinkSQLEngine x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.engineContext());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$main$3(Throwable x7$1, FlinkSQLEngine engine) {
        MODULE$.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> x7$1);
        engine.stop();
    }

    public static final /* synthetic */ void $anonfun$startEngine$1(FlinkSQLEngine engine) {
        engine.initialize(MODULE$.kyuubiConf());
        engine.start();
        Utils$.MODULE$.addShutdownHook(() -> engine.stop(), Utils$.MODULE$.FLINK_ENGINE_SHUTDOWN_PRIORITY() + 1);
    }

    public static final /* synthetic */ void $anonfun$discoverDependencies$1(ObjectRef dependencies$1, URL url) {
        JarUtils.checkJarFile((URL)url);
        dependencies$1.elem = ((ListBuffer)dependencies$1.elem).$plus$eq((Object)url);
    }

    public static final /* synthetic */ void $anonfun$discoverDependencies$3(ObjectRef dependencies$1, File f) {
        block0: {
            if (!f.isFile() || !f.getAbsolutePath().toLowerCase().endsWith(".jar")) break block0;
            URL url = f.toURI().toURL();
            JarUtils.checkJarFile((URL)url);
            dependencies$1.elem = ((ListBuffer)dependencies$1.elem).$plus$eq((Object)url);
        }
    }

    public static final /* synthetic */ void $anonfun$discoverDependencies$2(ObjectRef dependencies$1, URL libUrl) {
        File dir = new File(libUrl.toURI());
        if (!dir.isDirectory()) {
            throw new SqlClientException(new StringBuilder(20).append("Directory expected: ").append(dir).toString());
        }
        if (!dir.canRead()) {
            throw new SqlClientException(new StringBuilder(26).append("Directory cannot be read: ").append(dir).toString());
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new SqlClientException(new StringBuilder(26).append("Directory cannot be read: ").append(dir).toString());
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)f -> {
            FlinkSQLEngine$.$anonfun$discoverDependencies$3(dependencies$1, f);
            return BoxedUnit.UNIT;
        });
    }

    private FlinkSQLEngine$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.kyuubiConf = new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1());
        this.currentEngine = None$.MODULE$;
        this.user = Utils$.MODULE$.currentUser();
        this.org$apache$kyuubi$engine$flink$FlinkSQLEngine$$countDownLatch = new CountDownLatch(1);
    }
}

