/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.security.sasl.AuthenticationException;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap.Filter;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap.FilterFactory;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(HiveConf conf) {
        Collection userFilter = conf.getStringCollection(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER.varname);
        if (userFilter.isEmpty()) {
            return null;
        }
        return new UserFilter(userFilter);
    }

    private static final class UserFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(UserFilter.class);
        private final Set<String> userFilter = new HashSet<String>();

        UserFilter(Collection<String> userFilter) {
            for (String userFilterItem : userFilter) {
                this.userFilter.add(userFilterItem.toLowerCase());
            }
        }

        @Override
        public void apply(DirSearch ldap, String user) throws AuthenticationException {
            LOG.info("Authenticating user '{}' using user filter", (Object)user);
            String userName = LdapUtils.extractUserName(user).toLowerCase();
            if (!this.userFilter.contains(userName)) {
                LOG.info("Authentication failed based on user membership");
                throw new AuthenticationException("Authentication failed: User not a member of specified list");
            }
        }
    }
}

