/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.columnar;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.serde2.columnar.LazyDecompressionCallback;

public class BytesRefWritable
implements Writable,
Comparable<BytesRefWritable> {
    private static final byte[] EMPTY_BYTES = new byte[0];
    public static BytesRefWritable ZeroBytesRefWritable = new BytesRefWritable();
    int start = 0;
    int length = 0;
    byte[] bytes = null;
    LazyDecompressionCallback lazyDecompressObj;

    public BytesRefWritable() {
        this(EMPTY_BYTES);
    }

    public BytesRefWritable(int length) {
        assert (length > 0);
        this.length = length;
        this.bytes = new byte[this.length];
        this.start = 0;
    }

    public BytesRefWritable(byte[] bytes) {
        this.bytes = bytes;
        this.length = bytes.length;
        this.start = 0;
    }

    public BytesRefWritable(byte[] data, int offset, int len) {
        this.bytes = data;
        this.start = offset;
        this.length = len;
    }

    public BytesRefWritable(LazyDecompressionCallback lazyDecompressData, int offset, int len) {
        this.lazyDecompressObj = lazyDecompressData;
        this.start = offset;
        this.length = len;
    }

    private void lazyDecompress() throws IOException {
        if (this.bytes == null && this.lazyDecompressObj != null) {
            this.bytes = this.lazyDecompressObj.decompress();
        }
    }

    public byte[] getBytesCopy() throws IOException {
        this.lazyDecompress();
        byte[] bb = new byte[this.length];
        System.arraycopy(this.bytes, this.start, bb, 0, this.length);
        return bb;
    }

    public byte[] getData() throws IOException {
        this.lazyDecompress();
        return this.bytes;
    }

    public void set(byte[] newData, int offset, int len) {
        this.bytes = newData;
        this.start = offset;
        this.length = len;
        this.lazyDecompressObj = null;
    }

    public void set(LazyDecompressionCallback newData, int offset, int len) {
        this.bytes = null;
        this.start = offset;
        this.length = len;
        this.lazyDecompressObj = newData;
    }

    public void writeDataTo(DataOutput out) throws IOException {
        this.lazyDecompress();
        out.write(this.bytes, this.start, this.length);
    }

    public void readFields(DataInput in) throws IOException {
        int len = in.readInt();
        if (len > this.bytes.length) {
            this.bytes = new byte[len];
        }
        this.start = 0;
        this.length = len;
        in.readFully(this.bytes, this.start, this.length);
    }

    public void write(DataOutput out) throws IOException {
        this.lazyDecompress();
        out.writeInt(this.length);
        out.write(this.bytes, this.start, this.length);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(3 * this.length);
        for (int idx = this.start; idx < this.length; ++idx) {
            String num;
            if (idx != 0) {
                sb.append(' ');
            }
            if ((num = Integer.toHexString(0xFF & this.bytes[idx])).length() < 2) {
                sb.append('0');
            }
            sb.append(num);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(BytesRefWritable other) {
        if (other == null) {
            throw new IllegalArgumentException("Argument can not be null.");
        }
        if (this == other) {
            return 0;
        }
        try {
            return WritableComparator.compareBytes((byte[])this.getData(), (int)this.start, (int)this.getLength(), (byte[])other.getData(), (int)other.start, (int)other.getLength());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object right_obj) {
        if (right_obj == null || !(right_obj instanceof BytesRefWritable)) {
            return false;
        }
        return this.compareTo((BytesRefWritable)right_obj) == 0;
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    static {
        WritableFactories.setFactory(BytesRefWritable.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new BytesRefWritable();
            }
        });
    }
}

