/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.curator.utils.ZKPaths;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ServiceDiscovery$
implements Logging {
    public static ServiceDiscovery$ MODULE$;
    private ScheduledExecutorService org$apache$kyuubi$ha$client$ServiceDiscovery$$connectionChecker;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new ServiceDiscovery$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private ScheduledExecutorService connectionChecker$lzycompute() {
        ServiceDiscovery$ serviceDiscovery$ = this;
        synchronized (serviceDiscovery$) {
            if (!this.bitmap$0) {
                this.org$apache$kyuubi$ha$client$ServiceDiscovery$$connectionChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("zk-connection-checker");
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$kyuubi$ha$client$ServiceDiscovery$$connectionChecker;
    }

    public final ScheduledExecutorService org$apache$kyuubi$ha$client$ServiceDiscovery$$connectionChecker() {
        return !this.bitmap$0 ? this.connectionChecker$lzycompute() : this.org$apache$kyuubi$ha$client$ServiceDiscovery$$connectionChecker;
    }

    public boolean supportServiceDiscovery(KyuubiConf conf) {
        String zkEnsemble = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_QUORUM());
        return zkEnsemble != null && new StringOps(Predef$.MODULE$.augmentString(zkEnsemble)).nonEmpty();
    }

    public Option<Tuple2<String, Object>> getServerHost(CuratorFramework zkClient, String namespace) {
        None$ none$;
        Seq<ServiceNodeInfo> seq = this.getServiceNodesInfo(zkClient, namespace, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
            none$ = new Some((Object)new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Tuple2<String, Object>> getEngineByRefId(CuratorFramework zkClient, String namespace, String engineRefId) {
        CuratorFramework x$12 = zkClient;
        String x$2 = namespace;
        boolean x$3 = true;
        Option<Object> x$4 = this.getServiceNodesInfo$default$3();
        return this.getServiceNodesInfo(x$12, x$2, x$4, x$3).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ServiceDiscovery$.$anonfun$getEngineByRefId$1(engineRefId, x$1))).map((Function1 & Serializable & scala.Serializable)data -> new Tuple2((Object)data.host(), (Object)BoxesRunTime.boxToInteger((int)data.port())));
    }

    public Seq<ServiceNodeInfo> getServiceNodesInfo(CuratorFramework zkClient, String namespace, Option<Object> sizeOpt, boolean silent) {
        Nil$ nil$;
        try {
            List hosts = (List)zkClient.getChildren().forPath(namespace);
            int size = BoxesRunTime.unboxToInt((Object)sizeOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> hosts.size()));
            nil$ = (Seq)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hosts).asScala()).takeRight(size)).map((Function1 & Serializable & scala.Serializable)p -> {
                String path = ZKPaths.makePath((String)namespace, (String)p);
                String instance = new String((byte[])zkClient.getData().forPath(path), StandardCharsets.UTF_8);
                Tuple2<String, Object> tuple2 = MODULE$.parseInstanceHostPort(instance);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String host = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                Tuple2 tuple23 = tuple22;
                String host2 = (String)tuple23._1();
                int port2 = tuple23._2$mcI$sp();
                Option version = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.startsWith("version="))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringOps(Predef$.MODULE$.augmentString(x$5)).stripPrefix("version="));
                Option engineRefId = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.startsWith("refId="))).map((Function1 & Serializable & scala.Serializable)x$7 -> new StringOps(Predef$.MODULE$.augmentString(x$7)).stripPrefix("refId="));
                MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Get service instance:").append(instance).append(" and version:").append(version).append(" under ").append(namespace).toString());
                return new ServiceNodeInfo(namespace, (String)p, host2, port2, (Option<String>)version, (Option<String>)engineRefId);
            }, Buffer$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            if (silent) {
                nil$ = Nil$.MODULE$;
            } else {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get service node info", exception);
                nil$ = Nil$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return nil$;
    }

    public Option<Object> getServiceNodesInfo$default$3() {
        return None$.MODULE$;
    }

    public boolean getServiceNodesInfo$default$4() {
        return false;
    }

    @VisibleForTesting
    public Tuple2<String, Object> parseInstanceHostPort(String instance) {
        Tuple2 tuple2;
        Map maybeInfos = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instance.split(";"))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.split("=", 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ServiceDiscovery$.$anonfun$parseInstanceHostPort$2(x$9))))).map((Function1 & Serializable & scala.Serializable)i -> new Tuple2((Object)i[0], (Object)i[1]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        if (maybeInfos.size() > 0) {
            tuple2 = new Tuple2(maybeInfos.get((Object)"hive.server2.thrift.bind.host").get(), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString((String)maybeInfos.get((Object)"hive.server2.thrift.port").get())).toInt()));
        } else {
            String[] strings = instance.split(":");
            tuple2 = new Tuple2((Object)strings[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(strings[1])).toInt()));
        }
        return tuple2;
    }

    public String createAndGetServiceNode(KyuubiConf conf, CuratorFramework zkClient, String namespace, String instance, Option<String> version, boolean external) {
        return this.org$apache$kyuubi$ha$client$ServiceDiscovery$$createServiceNode(conf, zkClient, namespace, instance, version, external).getActualPath();
    }

    public Option<String> createAndGetServiceNode$default$5() {
        return None$.MODULE$;
    }

    public boolean createAndGetServiceNode$default$6() {
        return false;
    }

    public PersistentNode org$apache$kyuubi$ha$client$ServiceDiscovery$$createServiceNode(KyuubiConf conf, CuratorFramework zkClient, String namespace, String instance, Option<String> version, boolean external) {
        Object object;
        String ns = ZKPaths.makePath(null, (String)namespace);
        try {
            object = ((PathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(ns);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            object = BoxedUnit.UNIT;
        }
        catch (KeeperException e) {
            throw new KyuubiException(new StringBuilder(29).append("Failed to create namespace '").append(ns).append("'").toString(), (Throwable)e);
        }
        String session = (String)((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_REF_ID())).map((Function1 & Serializable & scala.Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String pathPrefix = ZKPaths.makePath((String)namespace, (String)new StringBuilder(30).append("serviceUri=").append(instance).append(";version=").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(";").append(session).append("sequence=").toString());
        ObjectRef serviceNode = ObjectRef.create(null);
        CreateMode createMode = external ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.EPHEMERAL_SEQUENTIAL;
        String znodeData = BoxesRunTime.unboxToBoolean((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_PUBLISH_CONFIGS())) && session.isEmpty() ? this.addConfsToPublish(conf, instance) : instance;
        try {
            serviceNode.elem = new PersistentNode(zkClient, createMode, false, pathPrefix, znodeData.getBytes(StandardCharsets.UTF_8));
            ((PersistentNode)serviceNode.elem).start();
            long znodeTimeout = BoxesRunTime.unboxToLong((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_NODE_TIMEOUT()));
            if (!((PersistentNode)serviceNode.elem).waitForInitialCreate(znodeTimeout, TimeUnit.MILLISECONDS)) {
                throw new KyuubiException(new StringBuilder(41).append("Max znode creation wait time ").append(znodeTimeout).append(" s exhausted").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Created a ").append(((PersistentNode)serviceNode$1.elem).getActualPath()).append(" on ZooKeeper for KyuubiServer uri: ").append(instance).toString());
        }
        catch (Exception e) {
            if ((PersistentNode)serviceNode.elem != null) {
                ((PersistentNode)serviceNode.elem).close();
            }
            throw new KyuubiException(new StringBuilder(51).append("Unable to create a znode for this server instance: ").append(instance).toString(), (Throwable)e);
        }
        return (PersistentNode)serviceNode.elem;
    }

    public Option<String> org$apache$kyuubi$ha$client$ServiceDiscovery$$createServiceNode$default$5() {
        return None$.MODULE$;
    }

    public boolean org$apache$kyuubi$ha$client$ServiceDiscovery$$createServiceNode$default$6() {
        return false;
    }

    private String addConfsToPublish(KyuubiConf conf, String instance) {
        if (!instance.contains(":")) {
            return instance;
        }
        String[] hostPort = instance.split(":", 2);
        scala.collection.mutable.Map confsToPublish = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.bind.host"), (Object)hostPort[0]));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.transport.mode"), (Object)"binary"));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.port"), (Object)hostPort[1]));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.sasl.qop"), conf.get(KyuubiConf$.MODULE$.SASL_QOP())));
        String authenticationMethod = ((TraversableOnce)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).mkString(",");
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.authentication"), (Object)authenticationMethod));
        Object object = authenticationMethod.equalsIgnoreCase("KERBEROS") ? confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.authentication.kerberos.principal"), ((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_PRINCIPAL())).map((Function1 & Serializable & scala.Serializable)principal -> KyuubiHadoopUtils$.MODULE$.getServerPrincipal(principal)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))) : BoxedUnit.UNIT;
        return ((TraversableOnce)confsToPublish.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(";");
    }

    public static final /* synthetic */ boolean $anonfun$getEngineByRefId$1(String engineRefId$1, ServiceNodeInfo x$1) {
        return x$1.engineRefId().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(engineRefId$1)));
    }

    public static final /* synthetic */ boolean $anonfun$parseInstanceHostPort$2(String[] x$9) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$9)).size() == 2;
    }

    private ServiceDiscovery$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

