/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.jdbc.hive.auth.KerberosUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAuthentication.class);
    private static final String KERBEROS_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private KerberosPrincipal principal = null;
    private final Configuration configuration;

    KerberosAuthentication(String ticketCache) {
        this.configuration = KerberosAuthentication.createLoginFromTgtCacheConfiguration(ticketCache);
    }

    KerberosAuthentication(String principal, String keytabLocation) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(keytabLocation, "keytabLocation is null");
        Path keytabPath = Paths.get(keytabLocation, new String[0]);
        Preconditions.checkArgument((boolean)Files.exists(keytabPath, new LinkOption[0]), (String)"keytab does not exist: %s", (Object)keytabLocation);
        Preconditions.checkArgument((boolean)Files.isReadable(keytabPath), (String)"keytab is not readable: %s", (Object)keytabLocation);
        this.principal = KerberosAuthentication.createKerberosPrincipal(principal);
        this.configuration = KerberosAuthentication.createLoginFromKeytabConfiguration(this.principal.getName(), keytabLocation);
    }

    public Subject getSubject() {
        Subject subject = this.principal == null ? null : new Subject(false, (Set<? extends Principal>)ImmutableSet.of((Object)this.principal), Collections.emptySet(), Collections.emptySet());
        try {
            LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    public void attemptLogin(Subject subject) {
        try {
            LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
            loginContext.login();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    private static KerberosPrincipal createKerberosPrincipal(String principal) {
        try {
            return new KerberosPrincipal(KerberosUtils.canonicalClientPrincipal(principal, InetAddress.getLocalHost().getCanonicalHostName()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Configuration createLoginFromTgtCacheConfiguration(String ticketCache) {
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder().put((Object)"useTicketCache", (Object)"true").put((Object)"renewTGT", (Object)"true");
        if (StringUtils.isBlank((CharSequence)ticketCache)) {
            ticketCache = System.getenv("KRB5CCNAME");
        }
        if (StringUtils.isNotBlank((CharSequence)ticketCache)) {
            if (!Files.exists(Paths.get(ticketCache, new String[0]), new LinkOption[0])) {
                LOG.warn("TicketCache {} does not exist", (Object)ticketCache);
            }
            optionsBuilder.put((Object)"ticketCache", (Object)ticketCache);
        }
        return KerberosAuthentication.createConfiguration((ImmutableMap.Builder<String, String>)optionsBuilder);
    }

    private static Configuration createLoginFromKeytabConfiguration(String principal, String keytabLocation) {
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder().put((Object)"useKeyTab", (Object)"true").put((Object)"storeKey", (Object)"true").put((Object)"refreshKrb5Config", (Object)"true").put((Object)"principal", (Object)principal).put((Object)"keyTab", (Object)keytabLocation);
        return KerberosAuthentication.createConfiguration((ImmutableMap.Builder<String, String>)optionsBuilder);
    }

    private static Configuration createConfiguration(ImmutableMap.Builder<String, String> optionsBuilder) {
        if (LOG.isDebugEnabled()) {
            optionsBuilder.put((Object)"debug", (Object)"true");
        }
        ImmutableMap options = optionsBuilder.put((Object)"doNotPrompt", (Object)"true").build();
        return new Configuration((Map)options){
            final /* synthetic */ Map val$options;
            {
                this.val$options = map;
            }

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosAuthentication.KERBEROS_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.val$options)};
            }
        };
    }
}

