/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.winegrower.deployer;

import java.util.Map;

import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

public class BundleCapabilityImpl implements BundleCapability {
    private final BundleRevision revision;
    private final String path;
    private final Map<String, String> directives;
    private final Map<String, Object> attributes;

    public BundleCapabilityImpl(final BundleRevision revision, final String path,
                                final Map<String, String> directives, final Map<String, Object> attributes) {
        this.revision = revision;
        this.path = path;
        this.directives = directives;
        this.attributes = attributes;
    }

    @Override
    public BundleRevision getRevision() {
        return revision;
    }

    @Override
    public String getNamespace() {
        return path;
    }

    @Override
    public Map<String, String> getDirectives() {
        return directives;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return attributes;
    }

    @Override
    public BundleRevision getResource() {
        return revision;
    }
}
