/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.internal;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.karaf.diagnostic.common.FeaturesDumpProvider;
import org.apache.karaf.diagnostic.common.LogDumpProvider;
import org.apache.karaf.diagnostic.core.DumpProvider;
import org.apache.karaf.diagnostic.management.internal.DiagnosticDumpMBeanImpl;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.util.tracker.SingleServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private List<ServiceRegistration<DumpProvider>> registrations;
    private ServiceRegistration<DumpProvider> featuresProviderRegistration;
    private ServiceRegistration mbeanRegistration;
    private SingleServiceTracker<FeaturesService> featuresServiceTracker;
    private ServiceTracker<DumpProvider, DumpProvider> providersTracker;

    public void start(BundleContext context) throws Exception {
        this.registrations = new ArrayList<ServiceRegistration<DumpProvider>>();
        this.registrations.add((ServiceRegistration<DumpProvider>)context.registerService(DumpProvider.class, (Object)new LogDumpProvider(context), null));
        this.featuresServiceTracker = new SingleServiceTracker<FeaturesService>(context, FeaturesService.class, (oldFs, newFs) -> {
            if (this.featuresProviderRegistration != null) {
                this.featuresProviderRegistration.unregister();
                this.featuresProviderRegistration = null;
            }
            if (newFs != null) {
                this.featuresProviderRegistration = context.registerService(DumpProvider.class, (Object)new FeaturesDumpProvider((FeaturesService)newFs), null);
            }
        });
        this.featuresServiceTracker.open();
        DiagnosticDumpMBeanImpl diagnostic = new DiagnosticDumpMBeanImpl();
        diagnostic.setBundleContext(context);
        Hashtable<String, CallSite> props = new Hashtable<String, CallSite>();
        props.put("jmx.objectname", (CallSite)((Object)("org.apache.karaf:type=diagnostic,name=" + System.getProperty("karaf.name"))));
        this.mbeanRegistration = context.registerService(this.getInterfaceNames(diagnostic), (Object)diagnostic, props);
    }

    public void stop(BundleContext context) throws Exception {
        this.mbeanRegistration.unregister();
        this.featuresServiceTracker.close();
        for (ServiceRegistration<DumpProvider> reg : this.registrations) {
            reg.unregister();
        }
    }

    private String[] getInterfaceNames(Object object) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> cl = object.getClass(); cl != Object.class; cl = cl.getSuperclass()) {
            this.addSuperInterfaces(names, cl);
        }
        return names.toArray(new String[names.size()]);
    }

    private void addSuperInterfaces(List<String> names, Class clazz) {
        for (Class<?> cl : clazz.getInterfaces()) {
            names.add(cl.getName());
            this.addSuperInterfaces(names, cl);
        }
    }
}

