/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.query.KeyQuery;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.ExceptionUtils;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheKeyValueBytesStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingKeyValueStore
extends WrappedStateStore<KeyValueStore<Bytes, byte[]>, byte[], byte[]>
implements KeyValueStore<Bytes, byte[]>,
CachedStateStore<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(CachingKeyValueStore.class);
    private CacheFlushListener<byte[], byte[]> flushListener;
    private boolean sendOldValues;
    private String cacheName;
    private InternalProcessorContext<?, ?> internalContext;
    private Thread streamThread;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Position position;
    private final boolean timestampedSchema;
    private final Map<Class, CacheQueryHandler> queryHandlers = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry(KeyQuery.class, (query, mergedPosition, positionBound, config, store) -> this.runKeyQuery(query, mergedPosition, positionBound, config))});

    CachingKeyValueStore(KeyValueStore<Bytes, byte[]> underlying, boolean timestampedSchema) {
        super(underlying);
        this.position = Position.emptyPosition();
        this.timestampedSchema = timestampedSchema;
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        this.internalContext = ProcessorContextUtils.asInternalProcessorContext(stateStoreContext);
        this.cacheName = ThreadCache.nameSpaceFromTaskIdAndStore(this.internalContext.taskId().toString(), this.name());
        this.internalContext.registerCacheFlushListener(this.cacheName, entries -> {
            for (ThreadCache.DirtyEntry entry : entries) {
                this.putAndMaybeForward(entry, this.internalContext);
            }
        });
        super.init(stateStoreContext, root);
        this.streamThread = Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Position getPosition() {
        Position mergedPosition = Position.emptyPosition();
        Position wrappedPosition = ((KeyValueStore)this.wrapped()).getPosition();
        Position position = this.position;
        synchronized (position) {
            Position position2 = wrappedPosition;
            synchronized (position2) {
                mergedPosition.merge(this.position);
                mergedPosition.merge(wrappedPosition);
            }
        }
        return mergedPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        long start = config.isCollectExecutionInfo() ? System.nanoTime() : -1L;
        CacheQueryHandler handler = this.queryHandlers.get(query.getClass());
        if (handler == null) {
            result = ((KeyValueStore)this.wrapped()).query(query, positionBound, config);
        } else {
            int partition = this.internalContext.taskId().partition();
            Lock lock = this.lock.readLock();
            lock.lock();
            try {
                this.validateStoreOpen();
                Position mergedPosition = this.getPosition();
                result = !StoreQueryUtils.isPermitted(mergedPosition, positionBound, partition) ? QueryResult.notUpToBound(mergedPosition, positionBound, partition) : handler.apply(query, mergedPosition, positionBound, config, this);
            }
            finally {
                lock.unlock();
            }
        }
        if (config.isCollectExecutionInfo()) {
            result.addExecutionInfo("Handled in " + String.valueOf(this.getClass()) + " in " + (System.nanoTime() - start) + "ns");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> QueryResult<R> runKeyQuery(Query<R> query, Position mergedPosition, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result = null;
        KeyQuery keyQuery = (KeyQuery)query;
        if (keyQuery.isSkipCache()) {
            return ((KeyValueStore)this.wrapped()).query(query, positionBound, config);
        }
        Bytes key = (Bytes)keyQuery.getKey();
        Position position = mergedPosition;
        synchronized (position) {
            LRUCacheEntry lruCacheEntry;
            if (this.internalContext.cache() != null && (lruCacheEntry = this.internalContext.cache().get(this.cacheName, key)) != null) {
                byte[] rawValue = this.timestampedSchema && !WrappedStateStore.isTimestamped(this.wrapped()) && !StoreQueryUtils.isAdapter(this.wrapped()) ? ValueAndTimestampDeserializer.rawValue(lruCacheEntry.value()) : lruCacheEntry.value();
                result = QueryResult.forResult(rawValue);
            }
            if (result == null) {
                result = ((KeyValueStore)this.wrapped()).query(query, PositionBound.unbounded(), config);
            }
            result.setPosition(mergedPosition.copy());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndMaybeForward(ThreadCache.DirtyEntry entry, InternalProcessorContext<?, ?> context) {
        if (this.flushListener != null) {
            byte[] rawOldValue;
            byte[] rawNewValue = entry.newValue();
            byte[] byArray = rawOldValue = rawNewValue == null || this.sendOldValues ? (byte[])((KeyValueStore)this.wrapped()).get(entry.key()) : null;
            if (rawNewValue != null || rawOldValue != null) {
                ProcessorRecordContext current = context.recordContext();
                try {
                    context.setRecordContext(entry.entry().context());
                    ((KeyValueStore)this.wrapped()).put(entry.key(), entry.newValue());
                    this.flushListener.apply(new Record<byte[], Change<byte[]>>(entry.key().get(), new Change<byte[]>(rawNewValue, (byte[])(this.sendOldValues ? rawOldValue : null)), entry.entry().context().timestamp(), entry.entry().context().headers()));
                }
                finally {
                    context.setRecordContext(current);
                }
            }
        } else {
            ProcessorRecordContext current = context.recordContext();
            try {
                context.setRecordContext(entry.entry().context());
                ((KeyValueStore)this.wrapped()).put(entry.key(), entry.newValue());
            }
            finally {
                context.setRecordContext(current);
            }
        }
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<byte[], byte[]> flushListener, boolean sendOldValues) {
        this.flushListener = flushListener;
        this.sendOldValues = sendOldValues;
        return true;
    }

    @Override
    public void put(Bytes key, byte[] value) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        this.lock.writeLock().lock();
        try {
            this.validateStoreOpen();
            this.putInternal(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInternal(Bytes key, byte[] value) {
        Position position = this.position;
        synchronized (position) {
            this.internalContext.cache().put(this.cacheName, key, new LRUCacheEntry(value, this.internalContext.headers(), true, this.internalContext.offset(), this.internalContext.timestamp(), this.internalContext.partition(), this.internalContext.topic()));
            StoreQueryUtils.updatePosition(this.position, this.internalContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] putIfAbsent(Bytes key, byte[] value) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        this.lock.writeLock().lock();
        try {
            this.validateStoreOpen();
            byte[] v = this.getInternal(key);
            if (v == null) {
                this.putInternal(key, value);
            }
            byte[] byArray = v;
            return byArray;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        this.validateStoreOpen();
        this.lock.writeLock().lock();
        try {
            this.validateStoreOpen();
            for (KeyValue<Bytes, byte[]> entry : entries) {
                Objects.requireNonNull((Bytes)entry.key, "key cannot be null");
                this.put((Bytes)entry.key, (byte[])entry.value);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public byte[] delete(Bytes key) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        this.lock.writeLock().lock();
        try {
            this.validateStoreOpen();
            byte[] byArray = this.deleteInternal(key);
            return byArray;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private byte[] deleteInternal(Bytes key) {
        byte[] v = this.getInternal(key);
        this.putInternal(key, null);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(Bytes key) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        Lock theLock = Thread.currentThread().equals(this.streamThread) ? this.lock.writeLock() : this.lock.readLock();
        theLock.lock();
        try {
            this.validateStoreOpen();
            byte[] byArray = this.getInternal(key);
            return byArray;
        }
        finally {
            theLock.unlock();
        }
    }

    private byte[] getInternal(Bytes key) {
        LRUCacheEntry entry = null;
        if (this.internalContext.cache() != null) {
            entry = this.internalContext.cache().get(this.cacheName, key);
        }
        if (entry == null) {
            byte[] rawValue = (byte[])((KeyValueStore)this.wrapped()).get(key);
            if (rawValue == null) {
                return null;
            }
            if (Thread.currentThread().equals(this.streamThread)) {
                this.internalContext.cache().put(this.cacheName, key, new LRUCacheEntry(rawValue));
            }
            return rawValue;
        }
        return entry.value();
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        if (Objects.nonNull(from) && Objects.nonNull(to) && from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        this.validateStoreOpen();
        KeyValueIterator<Bytes, byte[]> storeIterator = ((KeyValueStore)this.wrapped()).range(from, to);
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.internalContext.cache().range(this.cacheName, from, to);
        return new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)cacheIterator, storeIterator, true);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        if (Objects.nonNull(from) && Objects.nonNull(to) && from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        this.validateStoreOpen();
        KeyValueIterator<Bytes, byte[]> storeIterator = ((KeyValueStore)this.wrapped()).reverseRange(from, to);
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.internalContext.cache().reverseRange(this.cacheName, from, to);
        return new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)cacheIterator, storeIterator, false);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        this.validateStoreOpen();
        KeyValueIterator<Bytes, byte[]> storeIterator = ((KeyValueStore)this.wrapped()).all();
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.internalContext.cache().all(this.cacheName);
        return new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)cacheIterator, storeIterator, true);
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        this.validateStoreOpen();
        KeyValueIterator<Bytes, byte[]> storeIterator = ((KeyValueStore)this.wrapped()).prefixScan(prefix, prefixKeySerializer);
        Bytes from = Bytes.wrap((byte[])prefixKeySerializer.serialize(null, prefix));
        Bytes to = Bytes.increment((Bytes)from);
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.internalContext.cache().range(this.cacheName, from, to, false);
        return new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)cacheIterator, storeIterator, true);
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseAll() {
        this.validateStoreOpen();
        KeyValueIterator<Bytes, byte[]> storeIterator = ((KeyValueStore)this.wrapped()).reverseAll();
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.internalContext.cache().reverseAll(this.cacheName);
        return new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)cacheIterator, storeIterator, false);
    }

    @Override
    public long approximateNumEntries() {
        this.validateStoreOpen();
        this.lock.readLock().lock();
        try {
            this.validateStoreOpen();
            long l = ((KeyValueStore)this.wrapped()).approximateNumEntries();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void flush() {
        this.validateStoreOpen();
        this.lock.writeLock().lock();
        try {
            this.validateStoreOpen();
            this.internalContext.cache().flush(this.cacheName);
            ((KeyValueStore)this.wrapped()).flush();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void flushCache() {
        this.validateStoreOpen();
        this.lock.writeLock().lock();
        try {
            this.validateStoreOpen();
            this.internalContext.cache().flush(this.cacheName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clearCache() {
        this.validateStoreOpen();
        this.lock.writeLock().lock();
        try {
            this.validateStoreOpen();
            this.internalContext.cache().clear(this.cacheName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            Runnable[] runnableArray = new Runnable[3];
            runnableArray[0] = () -> this.internalContext.cache().flush(this.cacheName);
            runnableArray[1] = () -> this.internalContext.cache().close(this.cacheName);
            runnableArray[2] = ((KeyValueStore)this.wrapped())::close;
            LinkedList<RuntimeException> suppressed = ExceptionUtils.executeAll(runnableArray);
            if (!suppressed.isEmpty()) {
                ExceptionUtils.throwSuppressed("Caught an exception while closing caching key value store for store " + this.name(), suppressed);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @FunctionalInterface
    public static interface CacheQueryHandler {
        public QueryResult<?> apply(Query<?> var1, Position var2, PositionBound var3, QueryConfig var4, StateStore var5);
    }
}

