/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeShareGroupsResult;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.ShareGroupDescription;
import org.apache.kafka.clients.admin.ShareMemberDescription;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.consumer.group.ShareGroupCommandOptions;

public class ShareGroupCommand {
    public static void main(String[] args) {
        ShareGroupCommandOptions opts = new ShareGroupCommandOptions(args);
        try {
            opts.checkArgs();
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to list all share groups, describe a share group, delete share group info, or reset share group offsets.");
            long actions = Stream.of(opts.listOpt, opts.describeOpt, opts.deleteOpt, opts.resetOffsetsOpt, opts.deleteOffsetsOpt).filter(arg_0 -> ((OptionSet)opts.options).has(arg_0)).count();
            if (actions != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets.");
            }
            ShareGroupCommand.run(opts);
        }
        catch (OptionException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
    }

    public static void run(ShareGroupCommandOptions opts) {
        try (ShareGroupService shareGroupService = new ShareGroupService(opts, Map.of());){
            if (opts.options.has(opts.listOpt)) {
                shareGroupService.listGroups();
            } else if (opts.options.has(opts.describeOpt)) {
                shareGroupService.describeGroups();
            } else {
                if (opts.options.has(opts.deleteOpt)) {
                    throw new UnsupportedOperationException("--delete option is not yet implemented");
                }
                if (opts.options.has(opts.resetOffsetsOpt)) {
                    throw new UnsupportedOperationException("--reset-offsets option is not yet implemented");
                }
                if (opts.options.has(opts.deleteOffsetsOpt)) {
                    throw new UnsupportedOperationException("--delete-offsets option is not yet implemented");
                }
            }
        }
        catch (IllegalArgumentException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
        catch (Throwable e) {
            ShareGroupCommand.printError("Executing share group command failed due to " + e.getMessage(), Optional.of(e));
        }
    }

    static Set<GroupState> groupStatesFromString(String input) {
        Set<GroupState> parsedStates = Arrays.stream(input.split(",")).map(s -> GroupState.parse((String)s.trim())).collect(Collectors.toSet());
        Set validStates = GroupState.groupStatesForType((GroupType)GroupType.SHARE);
        if (!validStates.containsAll(parsedStates)) {
            throw new IllegalArgumentException("Invalid state list '" + input + "'. Valid states are: " + validStates.stream().map(GroupState::toString).collect(Collectors.joining(", ")));
        }
        return parsedStates;
    }

    public static void printError(String msg, Optional<Throwable> e) {
        System.out.println("\nError: " + msg);
        e.ifPresent(Throwable::printStackTrace);
    }

    static class ShareGroupService
    implements AutoCloseable {
        final ShareGroupCommandOptions opts;
        private final Admin adminClient;

        public ShareGroupService(ShareGroupCommandOptions opts, Map<String, String> configOverrides) {
            this.opts = opts;
            try {
                this.adminClient = this.createAdminClient(configOverrides);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShareGroupService(ShareGroupCommandOptions opts, Admin adminClient) {
            this.opts = opts;
            this.adminClient = adminClient;
        }

        public void listGroups() throws ExecutionException, InterruptedException {
            if (this.opts.options.has(this.opts.stateOpt)) {
                String stateValue = (String)this.opts.options.valueOf(this.opts.stateOpt);
                Set<GroupState> states = stateValue == null || stateValue.isEmpty() ? Set.of() : ShareGroupCommand.groupStatesFromString(stateValue);
                List<GroupListing> listings = this.listShareGroupsInStates(states);
                this.printGroupInfo(listings);
            } else {
                this.listShareGroups().forEach(System.out::println);
            }
        }

        List<String> listShareGroups() {
            try {
                ListGroupsResult result = this.adminClient.listGroups(((ListGroupsOptions)new ListGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).withTypes(Set.of(GroupType.SHARE)));
                Collection listings = (Collection)result.all().get();
                return listings.stream().map(GroupListing::groupId).collect(Collectors.toList());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        List<GroupListing> listShareGroupsInStates(Set<GroupState> states) throws ExecutionException, InterruptedException {
            ListGroupsResult result = this.adminClient.listGroups(((ListGroupsOptions)new ListGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).withTypes(Set.of(GroupType.SHARE)).inGroupStates(states));
            return new ArrayList<GroupListing>((Collection)result.all().get());
        }

        private void printGroupInfo(List<GroupListing> groups) {
            int maxGroupLen = 15;
            for (GroupListing group : groups) {
                maxGroupLen = Math.max(maxGroupLen, group.groupId().length());
            }
            System.out.printf("%" + -maxGroupLen + "s %s\n", "GROUP", "STATE");
            for (GroupListing group : groups) {
                String groupId = group.groupId();
                String state = group.groupState().orElse(GroupState.UNKNOWN).toString();
                System.out.printf("%" + -maxGroupLen + "s %s\n", groupId, state);
            }
        }

        public static boolean maybePrintEmptyGroupState(String group, GroupState state, int numRows) {
            if (state == GroupState.DEAD) {
                ShareGroupCommand.printError("Share group '" + group + "' does not exist.", Optional.empty());
            } else if (state == GroupState.EMPTY) {
                System.err.println("\nShare group '" + group + "' has no active members.");
            }
            return !state.equals((Object)GroupState.DEAD) && numRows > 0;
        }

        public void describeGroups() throws ExecutionException, InterruptedException {
            String group = (String)this.opts.options.valueOf(this.opts.groupOpt);
            ShareGroupDescription description = this.getDescribeGroup(group);
            if (description == null) {
                return;
            }
            if (this.opts.options.has(this.opts.membersOpt)) {
                this.printMembers(description);
            } else if (this.opts.options.has(this.opts.stateOpt)) {
                this.printStates(description);
            } else {
                this.printOffsets(description);
            }
        }

        ShareGroupDescription getDescribeGroup(String group) throws ExecutionException, InterruptedException {
            DescribeShareGroupsResult result = this.adminClient.describeShareGroups(List.of(group));
            Map descriptionMap = (Map)result.all().get();
            if (descriptionMap.containsKey(group)) {
                return (ShareGroupDescription)descriptionMap.get(group);
            }
            return null;
        }

        Map<TopicPartition, Long> getOffsets(Collection<ShareMemberDescription> members) throws ExecutionException, InterruptedException {
            HashSet allTp = new HashSet();
            for (ShareMemberDescription memberDescription : members) {
                allTp.addAll(memberDescription.assignment().topicPartitions());
            }
            HashMap<TopicPartition, OffsetSpec> earliest = new HashMap<TopicPartition, OffsetSpec>();
            HashMap<TopicPartition, OffsetSpec> latest = new HashMap<TopicPartition, OffsetSpec>();
            for (TopicPartition tp : allTp) {
                earliest.put(tp, OffsetSpec.earliest());
                latest.put(tp, OffsetSpec.latest());
            }
            Map earliestResult = (Map)this.adminClient.listOffsets(earliest).all().get();
            Map latestResult = (Map)this.adminClient.listOffsets(latest).all().get();
            HashMap<TopicPartition, Long> lag = new HashMap<TopicPartition, Long>();
            for (Map.Entry tp : earliestResult.entrySet()) {
                lag.put((TopicPartition)tp.getKey(), ((ListOffsetsResult.ListOffsetsResultInfo)latestResult.get(tp.getKey())).offset() - ((ListOffsetsResult.ListOffsetsResultInfo)earliestResult.get(tp.getKey())).offset());
            }
            return lag;
        }

        private void printOffsets(ShareGroupDescription description) throws ExecutionException, InterruptedException {
            Map<TopicPartition, Long> offsets = this.getOffsets(description.members());
            if (ShareGroupService.maybePrintEmptyGroupState(description.groupId(), description.groupState(), offsets.size())) {
                String fmt = ShareGroupService.printOffsetFormat(description, offsets);
                System.out.printf(fmt, "GROUP", "TOPIC", "PARTITION", "START-OFFSET");
                for (Map.Entry<TopicPartition, Long> offset : offsets.entrySet()) {
                    System.out.printf(fmt, description.groupId(), offset.getKey().topic(), offset.getKey().partition(), offset.getValue());
                }
            }
        }

        private static String printOffsetFormat(ShareGroupDescription description, Map<TopicPartition, Long> offsets) {
            int groupLen = Math.max(15, description.groupId().length());
            int maxTopicLen = 15;
            for (TopicPartition topicPartition : offsets.keySet()) {
                maxTopicLen = Math.max(maxTopicLen, topicPartition.topic().length());
            }
            return "%" + -groupLen + "s %" + -maxTopicLen + "s %-10s %s\n";
        }

        private void printStates(ShareGroupDescription description) {
            ShareGroupService.maybePrintEmptyGroupState(description.groupId(), description.groupState(), 1);
            int groupLen = Math.max(15, description.groupId().length());
            String coordinator = description.coordinator().host() + ":" + description.coordinator().port() + "  (" + description.coordinator().idString() + ")";
            int coordinatorLen = Math.max(25, coordinator.length());
            String fmt = "%" + -groupLen + "s %" + -coordinatorLen + "s %-15s %s\n";
            System.out.printf(fmt, "GROUP", "COORDINATOR (ID)", "STATE", "#MEMBERS");
            System.out.printf(fmt, description.groupId(), coordinator, description.groupState().toString(), description.members().size());
        }

        private void printMembers(ShareGroupDescription description) {
            int groupLen = Math.max(15, description.groupId().length());
            int maxConsumerIdLen = 15;
            int maxHostLen = 15;
            int maxClientIdLen = 15;
            Collection members = description.members();
            if (ShareGroupService.maybePrintEmptyGroupState(description.groupId(), description.groupState(), description.members().size())) {
                for (ShareMemberDescription member : members) {
                    maxConsumerIdLen = Math.max(maxConsumerIdLen, member.consumerId().length());
                    maxHostLen = Math.max(maxHostLen, member.host().length());
                    maxClientIdLen = Math.max(maxClientIdLen, member.clientId().length());
                }
                String fmt = "%" + -groupLen + "s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %s\n";
                System.out.printf(fmt, "GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "ASSIGNMENT");
                for (ShareMemberDescription member : members) {
                    System.out.printf(fmt, description.groupId(), member.consumerId(), member.host(), member.clientId(), member.assignment().topicPartitions().stream().map(part -> part.topic() + ":" + part.partition()).collect(Collectors.joining(",")));
                }
            }
        }

        @Override
        public void close() {
            this.adminClient.close();
        }

        protected Admin createAdminClient(Map<String, String> configOverrides) throws IOException {
            Properties props = this.opts.options.has(this.opts.commandConfigOpt) ? Utils.loadProps((String)((String)this.opts.options.valueOf(this.opts.commandConfigOpt))) : new Properties();
            props.put("bootstrap.servers", this.opts.options.valueOf(this.opts.bootstrapServerOpt));
            props.putAll(configOverrides);
            return Admin.create((Properties)props);
        }
    }
}

