/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.lang.reflect.InvocationTargetException;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.kafka.common.internals.SecurityManagerCompatibility;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.runtime.isolation.LoaderSwap;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginSource;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginScanner {
    private static final Logger log = LoggerFactory.getLogger(PluginScanner.class);

    public PluginScanResult discoverPlugins(Set<PluginSource> sources) {
        long startMs = System.currentTimeMillis();
        ArrayList<PluginScanResult> results = new ArrayList<PluginScanResult>();
        for (PluginSource source : sources) {
            results.add(this.scanUrlsAndAddPlugins(source));
        }
        long endMs = System.currentTimeMillis();
        log.info("Scanning plugins with {} took {} ms", (Object)this.getClass().getSimpleName(), (Object)(endMs - startMs));
        return new PluginScanResult(results);
    }

    private PluginScanResult scanUrlsAndAddPlugins(PluginSource source) {
        log.info("Loading plugin from: {}", (Object)source);
        if (log.isDebugEnabled()) {
            log.debug("Loading plugin urls: {}", (Object)Arrays.toString(source.urls()));
        }
        PluginScanResult plugins = this.scanPlugins(source);
        log.info("Registered loader: {}", (Object)source.loader());
        this.loadJdbcDrivers(source.loader());
        return plugins;
    }

    protected abstract PluginScanResult scanPlugins(PluginSource var1);

    private void loadJdbcDrivers(ClassLoader loader) {
        SecurityManagerCompatibility.get().doPrivileged(() -> {
            ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class, loader);
            Iterator<Driver> driversIterator = loadedDrivers.iterator();
            try {
                while (driversIterator.hasNext()) {
                    Driver driver = driversIterator.next();
                    log.debug("Registered java.sql.Driver: {} to java.sql.DriverManager", (Object)driver);
                }
            }
            catch (Throwable t) {
                log.debug("Ignoring java.sql.Driver classes listed in resources but not present in class loader's classpath: ", t);
            }
            return null;
        });
    }

    protected <T> PluginDesc<T> pluginDesc(Class<? extends T> plugin, String version, PluginType type, PluginSource source) {
        return new PluginDesc<T>(plugin, version, type, source.loader());
    }

    protected <T> SortedSet<PluginDesc<T>> getServiceLoaderPluginDesc(PluginType type, PluginSource source) {
        TreeSet<PluginDesc<T>> result = new TreeSet<PluginDesc<T>>();
        ServiceLoader<?> serviceLoader = ServiceLoader.load(type.superClass(), source.loader());
        Iterator<?> iterator = serviceLoader.iterator();
        while (this.handleLinkageError(type, source, iterator::hasNext).booleanValue()) {
            Object pluginImpl;
            LoaderSwap loaderSwap = this.withClassLoader(source.loader());
            try {
                pluginImpl = this.handleLinkageError(type, source, iterator::next);
            }
            catch (ServiceConfigurationError t) {
                log.error("Failed to discover {} in {}{}", new Object[]{type.simpleName(), source, PluginScanner.reflectiveErrorDescription(t.getCause()), t});
                if (loaderSwap == null) continue;
                loaderSwap.close();
                continue;
            }
            try {
                Class<?> pluginKlass = pluginImpl.getClass();
                if (pluginKlass.getClassLoader() != source.loader()) {
                    log.debug("{} from other classloader {} is visible from {}, excluding to prevent isolated loading", new Object[]{type.simpleName(), pluginKlass.getClassLoader(), source});
                    continue;
                }
                result.add(this.pluginDesc(pluginKlass, PluginScanner.versionFor(pluginImpl), type, source));
            }
            finally {
                if (loaderSwap == null) continue;
                loaderSwap.close();
            }
        }
        return result;
    }

    private <U> U handleLinkageError(PluginType type, PluginSource source, Supplier<U> function) {
        Object lastError = null;
        for (int i = 0; i < 100; ++i) {
            try {
                return function.get();
            }
            catch (LinkageError t) {
                if (lastError == null || !Objects.equals(lastError.getClass(), t.getClass()) || !Objects.equals(((Throwable)lastError).getMessage(), t.getMessage())) {
                    log.error("Failed to discover {} in {}{}", new Object[]{type.simpleName(), source, PluginScanner.reflectiveErrorDescription(t.getCause()), t});
                }
                lastError = t;
                continue;
            }
        }
        log.error("Received excessive ServiceLoader errors: assuming the runtime ServiceLoader implementation cannot skip faulty implementations. Use a different JRE, or resolve LinkageErrors for plugins in {}", (Object)source, lastError);
        throw lastError;
    }

    protected static <T> String versionFor(T pluginImpl) {
        try {
            if (pluginImpl instanceof Versioned) {
                return ((Versioned)pluginImpl).version();
            }
        }
        catch (Throwable t) {
            log.error("Failed to get plugin version for " + String.valueOf(pluginImpl.getClass()), t);
        }
        return "undefined";
    }

    protected static String reflectiveErrorDescription(Throwable t) {
        if (t instanceof NoSuchMethodException) {
            return ": Plugin class must have a no-args constructor, and cannot be a non-static inner class";
        }
        if (t instanceof SecurityException) {
            return ": Security settings must allow reflective instantiation of plugin classes";
        }
        if (t instanceof IllegalAccessException) {
            return ": Plugin class default constructor must be public";
        }
        if (t instanceof ExceptionInInitializerError) {
            return ": Failed to statically initialize plugin class";
        }
        if (t instanceof InvocationTargetException) {
            return ": Failed to invoke plugin constructor";
        }
        if (t instanceof LinkageError) {
            return ": Plugin class has a dependency which is missing or invalid";
        }
        return "";
    }

    protected LoaderSwap withClassLoader(ClassLoader loader) {
        ClassLoader savedLoader = Plugins.compareAndSwapLoaders(loader);
        try {
            return new LoaderSwap(savedLoader);
        }
        catch (Throwable t) {
            Plugins.compareAndSwapLoaders(savedLoader);
            throw t;
        }
    }
}

