/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.internal.DelegateBeanMap;
import org.apache.juneau.internal.DelegateMap;
import org.apache.juneau.objecttools.ObjectTool;
import org.apache.juneau.objecttools.ViewArgs;

public class ObjectViewer
implements ObjectTool<ViewArgs> {
    public static final ObjectViewer DEFAULT = new ObjectViewer();

    public static ObjectViewer create() {
        return new ObjectViewer();
    }

    @Override
    public Object run(BeanSession session, Object input, ViewArgs args) {
        if (input == null) {
            return null;
        }
        List<String> view = args.getView();
        ClassMeta<Object> type = session.getClassMetaForObject(input);
        if (type.isBeanMap()) {
            return new DelegateBeanMap(((BeanMap)input).getBean(), session).filterKeys(view);
        }
        if (type.isMap()) {
            return new DelegateMap<Map>((Map)input, session).filterKeys(view);
        }
        if (type.isBean()) {
            return new DelegateBeanMap<Object>(input, session).filterKeys(view);
        }
        ArrayList<Object> l = null;
        if (type.isArray()) {
            int size = Array.getLength(input);
            l = CollectionUtils.listOfSize(size);
            for (int i = 0; i < size; ++i) {
                l.add(Array.get(input, i));
            }
        } else if (type.isCollection()) {
            Collection c = (Collection)input;
            ArrayList<Object> l2 = l = CollectionUtils.listOfSize(c.size());
            c.forEach(x -> l2.add(x));
        } else {
            return input;
        }
        ListIterator li = l.listIterator();
        while (li.hasNext()) {
            Object o = li.next();
            ClassMeta cm2 = session.getClassMetaForObject(o);
            if (cm2 == null) {
                o = null;
            } else if (cm2.isBeanMap()) {
                o = new DelegateBeanMap(((BeanMap)o).getBean(), session).filterKeys(view);
            } else if (cm2.isMap()) {
                o = new DelegateMap<Map>((Map)o, session).filterKeys(view);
            } else if (cm2.isBean()) {
                o = new DelegateBeanMap(o, session).filterKeys(view);
            }
            li.set(o);
        }
        return l;
    }

    public List<Map> run(Object input, String args) {
        return (List)this.run(BeanContext.DEFAULT_SESSION, input, ViewArgs.create(args));
    }

    public Map runSingle(Object input, String args) {
        return (Map)this.run(BeanContext.DEFAULT_SESSION, input, ViewArgs.create(args));
    }
}

