/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotatableType;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassArrayFormat;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassNameFormat;
import org.apache.juneau.commons.reflect.ElementFlag;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class MethodInfo
extends ExecutableInfo
implements Comparable<MethodInfo>,
Annotatable {
    private final Method inner;
    private final Supplier<ClassInfo> returnType;
    private final Supplier<List<MethodInfo>> matchingMethods;
    private final Supplier<List<AnnotationInfo<Annotation>>> annotations;

    public static MethodInfo of(Class<?> declaringClass, Method inner) {
        return ClassInfo.of(declaringClass).getMethod(inner);
    }

    public static MethodInfo of(ClassInfo declaringClass, Method inner) {
        AssertionUtils.assertArgNotNull("declaringClass", declaringClass);
        return declaringClass.getMethod(inner);
    }

    public static MethodInfo of(Method inner) {
        AssertionUtils.assertArgNotNull("inner", inner);
        return ClassInfo.of(inner.getDeclaringClass()).getMethod(inner);
    }

    protected MethodInfo(ClassInfo declaringClass, Method inner) {
        super(declaringClass, inner);
        this.inner = inner;
        this.returnType = Utils.mem(() -> ClassInfo.of(inner.getReturnType(), inner.getGenericReturnType()));
        this.matchingMethods = Utils.mem(this::findMatchingMethods);
        this.annotations = Utils.mem(() -> this.getMatchingMethods().stream().flatMap(m -> m.getDeclaredAnnotations().stream()).toList());
    }

    @Override
    public MethodInfo accessible() {
        super.accessible();
        return this;
    }

    @Override
    public int compareTo(MethodInfo o) {
        int i = Utils.cmp(this.getSimpleName(), o.getSimpleName());
        if (i == 0) {
            List<ParameterInfo> params = this.getParameters();
            List<ParameterInfo> oParams = o.getParameters();
            i = params.size() - oParams.size();
            if (i == 0) {
                for (int j = 0; j < params.size() && i == 0; ++j) {
                    i = Utils.cmp(params.get(j).getParameterType().getName(), oParams.get(j).getParameterType().getName());
                }
            }
        }
        return i;
    }

    @Override
    public AnnotatableType getAnnotatableType() {
        return AnnotatableType.METHOD_TYPE;
    }

    public AnnotatedType getAnnotatedReturnType() {
        return this.inner.getAnnotatedReturnType();
    }

    public List<AnnotationInfo<Annotation>> getAnnotations() {
        return this.annotations.get();
    }

    public <A extends Annotation> Stream<AnnotationInfo<A>> getAnnotations(Class<A> type) {
        AssertionUtils.assertArgNotNull("type", type);
        return this.getAnnotations().stream().filter(a -> a.isType(type)).map(a -> a);
    }

    public Object getDefaultValue() {
        return this.inner.getDefaultValue();
    }

    public Type getGenericReturnType() {
        return this.inner.getGenericReturnType();
    }

    @Override
    public String getLabel() {
        return this.getDeclaringClass().getNameSimple() + "." + this.getShortName();
    }

    public List<MethodInfo> getMatchingMethods() {
        return this.matchingMethods.get();
    }

    public String getName() {
        return this.inner.getName();
    }

    public String getPropertyName() {
        String n = this.inner.getName();
        if ((n.startsWith("get") || n.startsWith("set")) && n.length() > 3) {
            return Introspector.decapitalize(n.substring(3));
        }
        if (n.startsWith("is") && n.length() > 2) {
            return Introspector.decapitalize(n.substring(2));
        }
        return n;
    }

    public ClassInfo getReturnType() {
        return this.returnType.get();
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.inner.getName());
        List<ParameterInfo> params = this.getParameters();
        if (params.size() > 0) {
            sb.append('(');
            for (int i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                params.get(i).getParameterType().appendNameFormatted(sb, ClassNameFormat.FULL, true, '$', ClassArrayFormat.BRACKETS);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean hasAllParameters(Class<?> ... requiredParams) {
        List<Class> paramTypes = this.getParameters().stream().map(p -> p.getParameterType().inner()).toList();
        for (Class<?> c : requiredParams) {
            if (paramTypes.contains(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.getAnnotations(type).findAny().isPresent();
    }

    public boolean hasOnlyParameterTypes(Class<?> ... args) {
        for (ParameterInfo param : this.getParameters()) {
            Class c1 = param.getParameterType().inner();
            boolean foundMatch = false;
            for (Class<?> c2 : args) {
                if (c1 != c2) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    public boolean hasParameter(Class<?> requiredParam) {
        return this.hasAllParameters(requiredParam);
    }

    public boolean hasReturnType(Class<?> c) {
        return this.inner.getReturnType() == c;
    }

    public boolean hasReturnType(ClassInfo ci) {
        return this.hasReturnType(ci.inner());
    }

    public boolean hasReturnTypeParent(Class<?> c) {
        return ClassInfo.of(c).isParentOf(this.inner.getReturnType());
    }

    public boolean hasReturnTypeParent(ClassInfo ci) {
        return this.hasReturnTypeParent(ci.inner());
    }

    public Method inner() {
        return this.inner;
    }

    public boolean equals(Object obj) {
        MethodInfo other;
        return obj instanceof MethodInfo && Utils.eq(this, other = (MethodInfo)obj, (x, y) -> Utils.eq(x.inner, y.inner) && Utils.eq(x.declaringClass, y.declaringClass));
    }

    public int hashCode() {
        return 31 * this.inner.hashCode() + this.declaringClass.hashCode();
    }

    public <T> T invoke(Object obj, Object ... args) throws ExecutableException {
        return (T)Utils.safe(() -> {
            try {
                return this.inner.invoke(obj, args);
            }
            catch (InvocationTargetException e) {
                throw ThrowableUtils.exex(e.getTargetException());
            }
        }, e -> ThrowableUtils.exex(e));
    }

    public Object invokeLenient(Object pojo, Object ... args) throws ExecutableException {
        return Utils.safe(() -> this.inner.invoke(pojo, ClassUtils.getMatchingArgs(this.inner.getParameterTypes(), args)), e -> ThrowableUtils.exex(e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e));
    }

    @Override
    public boolean is(ElementFlag flag) {
        return switch (flag) {
            case ElementFlag.BRIDGE -> this.isBridge();
            case ElementFlag.NOT_BRIDGE -> {
                if (!this.isBridge()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.DEFAULT -> this.isDefault();
            case ElementFlag.NOT_DEFAULT -> {
                if (!this.isDefault()) {
                    yield true;
                }
                yield false;
            }
            default -> super.is(flag);
        };
    }

    public boolean isBridge() {
        return this.inner.isBridge();
    }

    public boolean isDefault() {
        return this.inner.isDefault();
    }

    public boolean matches(MethodInfo m) {
        return this.hasName(m.getName()) && this.hasMatchingParameters(m.getParameters());
    }

    private void addMatchingMethodsFromInterface(List<MethodInfo> result, ClassInfo iface) {
        iface.getDeclaredMethods().stream().filter(this::matches).forEach(result::add);
        iface.getDeclaredInterfaces().stream().forEach(pi -> this.addMatchingMethodsFromInterface(result, (ClassInfo)pi));
    }

    private List<MethodInfo> findMatchingMethods() {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        result.add(this);
        ClassInfo cc = this.getDeclaringClass();
        while (Utils.nn(cc)) {
            cc.getDeclaredInterfaces().stream().forEach(di -> this.addMatchingMethodsFromInterface((List<MethodInfo>)result, (ClassInfo)di));
            if (!Utils.nn(cc = cc.getSuperclass())) continue;
            cc.getDeclaredMethods().stream().filter(this::matches).findFirst().ifPresent(result::add);
        }
        return result;
    }
}

