/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.annotation.AnnotationGroup;
import org.apache.juneau.annotation.ContextApply;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.svl.VarResolverSession;

public final class AnnotationInfo<T extends Annotation> {
    private final ClassInfo c;
    private final MethodInfo m;
    private final Package p;
    private final T a;
    private volatile Method[] methods;
    final int rank;
    private Constructor<? extends AnnotationApplier<?, ?>>[] applyConstructors;

    AnnotationInfo(ClassInfo c, MethodInfo m, Package p, T a) {
        this.c = c;
        this.m = m;
        this.p = p;
        this.a = a;
        this.rank = AnnotationInfo.getRank(a);
    }

    private static int getRank(Object a) {
        ClassInfo ci = ClassInfo.of(a);
        MethodInfo mi = ci.getPublicMethod(x -> x.hasName("rank") && x.hasNoParams() && x.hasReturnType(Integer.TYPE));
        if (mi != null) {
            try {
                return (Integer)mi.invoke(a, new Object[0]);
            }
            catch (ExecutableException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static <A extends Annotation> AnnotationInfo<A> of(ClassInfo onClass, A value) {
        return new AnnotationInfo<A>(onClass, null, null, value);
    }

    public static <A extends Annotation> AnnotationInfo<A> of(MethodInfo onMethod, A value) {
        return new AnnotationInfo<A>(null, onMethod, null, value);
    }

    public static <A extends Annotation> AnnotationInfo<A> of(Package onPackage, A value) {
        return new AnnotationInfo<A>(null, null, onPackage, value);
    }

    public ClassInfo getClassOn() {
        return this.c;
    }

    public MethodInfo getMethodOn() {
        return this.m;
    }

    public Package getPackageOn() {
        return this.p;
    }

    public T inner() {
        return this.a;
    }

    public String getName() {
        return this.a.annotationType().getSimpleName();
    }

    public JsonMap toJsonMap() {
        JsonMap jm = new JsonMap();
        if (this.c != null) {
            jm.put("class", (Object)this.c.getSimpleName());
        }
        if (this.m != null) {
            jm.put("method", (Object)this.m.getShortName());
        }
        if (this.p != null) {
            jm.put("package", (Object)this.p.getName());
        }
        JsonMap ja = new JsonMap();
        ClassInfo ca = ClassInfo.of(this.a.annotationType());
        ca.forEachDeclaredMethod(null, x -> {
            try {
                Object v = x.invoke(this.a, new Object[0]);
                Object d = x.inner().getDefaultValue();
                if (ObjectUtils.ne(v, d) && (!ArrayUtils.isArray(v) || Array.getLength(v) != 0 || Array.getLength(d) != 0)) {
                    ja.put(this.m.getName(), v);
                }
            }
            catch (Exception e) {
                ja.put(this.m.getName(), (Object)e.getLocalizedMessage());
            }
        });
        jm.put("@" + ca.getSimpleName(), (Object)ja);
        return jm;
    }

    public AnnotationInfo<T> getApplies(VarResolverSession vrs, Consumer<AnnotationApplier<Annotation, Object>> consumer) throws ExecutableException {
        try {
            if (this.applyConstructors == null) {
                ContextApply cpa = this.a.annotationType().getAnnotation(ContextApply.class);
                if (cpa == null) {
                    this.applyConstructors = new Constructor[]{AnnotationApplier.NoOp.class.getConstructor(VarResolverSession.class)};
                } else {
                    this.applyConstructors = new Constructor[cpa.value().length];
                    for (int i = 0; i < cpa.value().length; ++i) {
                        this.applyConstructors[i] = cpa.value()[i].getConstructor(VarResolverSession.class);
                    }
                }
            }
            for (Constructor<? extends AnnotationApplier<?, ?>> applyConstructor : this.applyConstructors) {
                consumer.accept((AnnotationApplier)applyConstructor.newInstance(vrs));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
        return this;
    }

    public ClassInfo getClassInfo() {
        if (this.c != null) {
            return this.c;
        }
        if (this.m != null) {
            return this.m.getDeclaringClass();
        }
        return null;
    }

    public <A extends Annotation> boolean isType(Class<A> type) {
        Class<? extends Annotation> at = this.a.annotationType();
        return at == type;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.a.annotationType().getAnnotation(type) != null;
    }

    public <A extends Annotation> boolean isInGroup(Class<A> group) {
        AnnotationGroup x = this.a.annotationType().getAnnotation(AnnotationGroup.class);
        return x != null && x.value().equals(group);
    }

    public boolean matches(Predicate<AnnotationInfo<?>> test) {
        return ConsumerUtils.test(test, this);
    }

    public AnnotationInfo<?> accept(Predicate<AnnotationInfo<?>> test, Consumer<AnnotationInfo<?>> action) {
        if (this.matches(test)) {
            action.accept(this);
        }
        return this;
    }

    public String toString() {
        return Json5.DEFAULT_READABLE.write(this.toJsonMap());
    }

    public <V> AnnotationInfo<?> forEachValue(Class<V> type, String name, Predicate<V> test, Consumer<V> action) {
        for (Method m : this._getMethods()) {
            if (!m.getName().equals(name) || !m.getReturnType().equals(type)) continue;
            ThrowableUtils.safeRun(() -> ConsumerUtils.consume(test, action, m.invoke(this.a, new Object[0])));
        }
        return this;
    }

    public <V> Optional<V> getValue(Class<V> type, String name, Predicate<V> test) {
        for (Method m : this._getMethods()) {
            if (!m.getName().equals(name) || !m.getReturnType().equals(type)) continue;
            try {
                Object v = m.invoke(this.a, new Object[0]);
                if (!ConsumerUtils.test(test, v)) continue;
                return CollectionUtils.optional(v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return CollectionUtils.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Method[] _getMethods() {
        if (this.methods == null) {
            AnnotationInfo annotationInfo = this;
            synchronized (annotationInfo) {
                this.methods = this.a.annotationType().getMethods();
            }
        }
        return this.methods;
    }
}

