/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

@Header
@Schema(type="integer", format="int32")
public class BasicIntegerHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Integer value;
    private final Supplier<Integer> supplier;

    public static BasicIntegerHeader of(String name, String value) {
        return value == null ? null : new BasicIntegerHeader(name, value);
    }

    public static BasicIntegerHeader of(String name, Integer value) {
        return value == null ? null : new BasicIntegerHeader(name, value);
    }

    public static BasicIntegerHeader of(String name, Supplier<Integer> value) {
        return value == null ? null : new BasicIntegerHeader(name, value);
    }

    public BasicIntegerHeader(String name, String value) {
        super(name, value);
        this.value = this.parse(value);
        this.supplier = null;
    }

    public BasicIntegerHeader(String name, Integer value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicIntegerHeader(String name, Supplier<Integer> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify(this.value());
    }

    public Optional<Integer> asInteger() {
        return CollectionUtils.optional(this.value());
    }

    public Integer toInteger() {
        return this.value();
    }

    public FluentIntegerAssertion<BasicIntegerHeader> assertInteger() {
        return new FluentIntegerAssertion<BasicIntegerHeader>(this.value(), this);
    }

    public Integer orElse(Integer other) {
        Integer x = this.value();
        return x != null ? x : other;
    }

    private Integer parse(String value) {
        try {
            return value == null ? null : Integer.valueOf(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw ThrowableUtils.runtimeException("Value ''{0}'' could not be parsed as an integer.", value);
        }
    }

    private Integer value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

