/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.util.Collections;
import java.util.Map;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.SimpleMap;
import org.apache.juneau.internal.StringUtils;

public class UrlPathMatch {
    private final int matchedParts;
    private final String path;
    private final Map<String, String> vars;

    protected UrlPathMatch(String path, int matchedParts, String[] keys, String[] values) {
        this.path = path;
        this.matchedParts = matchedParts;
        this.vars = keys == null ? Collections.emptyMap() : new SimpleMap<String, String>(keys, values);
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public boolean hasVars() {
        return !this.vars.isEmpty();
    }

    public boolean hasEmptyVars() {
        for (String v : this.vars.values()) {
            if (!StringUtils.isEmpty(v)) continue;
            return true;
        }
        return false;
    }

    public String getRemainder() {
        String suffix = this.getSuffix();
        if (StringUtils.isNotEmpty(suffix) && suffix.charAt(0) == '/') {
            suffix = suffix.substring(1);
        }
        return suffix;
    }

    public String getSuffix() {
        String s = this.path;
        for (int j = 0; j < this.matchedParts; ++j) {
            int k = s.indexOf(47, 1);
            if (k == -1) {
                return null;
            }
            s = s.substring(k);
        }
        return s;
    }

    public String getPrefix() {
        int c = 0;
        for (int j = 0; j < this.matchedParts; ++j) {
            if ((c = this.path.indexOf(47, c + 1)) != -1) continue;
            c = this.path.length();
        }
        return StringUtils.nullIfEmpty(this.path.substring(0, c));
    }

    public String toString() {
        return JsonMap.filteredMap().append("v", this.getVars()).append("r", this.getRemainder()).asString();
    }
}

