/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.http.header.MediaRange;
import org.apache.juneau.http.header.MediaRanges;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

public class BasicMediaRangesHeader
extends BasicStringHeader {
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final MediaRanges value;
    private final Supplier<MediaRanges> supplier;

    public static BasicMediaRangesHeader of(String name, String value) {
        return value == null ? null : new BasicMediaRangesHeader(name, value);
    }

    public static BasicMediaRangesHeader of(String name, MediaRanges value) {
        return value == null ? null : new BasicMediaRangesHeader(name, value);
    }

    public BasicMediaRangesHeader(String name, String value) {
        super(name, value);
        this.stringValue = value;
        this.value = this.parse(value);
        this.supplier = null;
    }

    public BasicMediaRangesHeader(String name, MediaRanges value) {
        super(name, StringUtils.stringify(value));
        this.stringValue = null;
        this.value = value;
        this.supplier = null;
    }

    public BasicMediaRangesHeader(String name, Supplier<MediaRanges> value) {
        super(name, (String)null);
        this.stringValue = null;
        this.value = null;
        this.supplier = value;
    }

    public Optional<MediaRanges> asMediaRanges() {
        return CollectionUtils.optional(this.value());
    }

    public MediaRanges toMediaRanges() {
        return this.value();
    }

    public int match(List<? extends MediaType> mediaTypes) {
        MediaRanges x = this.value();
        return x == null ? -1 : x.match(mediaTypes);
    }

    public MediaRange getRange(int index) {
        MediaRanges x = this.value();
        return x == null ? null : x.getRange(index);
    }

    public boolean hasSubtypePart(String part) {
        MediaRanges x = this.value();
        return x == null ? false : x.hasSubtypePart(part);
    }

    @Override
    public String getValue() {
        return this.stringValue != null ? this.stringValue : StringUtils.stringify(this.value());
    }

    public MediaRanges orElse(MediaRanges other) {
        MediaRanges x = this.value();
        return x != null ? x : other;
    }

    private MediaRanges parse(String value) {
        return value == null ? null : MediaRanges.of(value);
    }

    private MediaRanges value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

