/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

@Header
@Schema(type="integer", format="int64")
public class BasicLongHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Long value;
    private final Supplier<Long> supplier;

    public static BasicLongHeader of(String name, String value) {
        return value == null ? null : new BasicLongHeader(name, value);
    }

    public static BasicLongHeader of(String name, Long value) {
        return value == null ? null : new BasicLongHeader(name, value);
    }

    public static BasicLongHeader of(String name, Supplier<Long> value) {
        return value == null ? null : new BasicLongHeader(name, value);
    }

    public BasicLongHeader(String name, String value) {
        super(name, value);
        this.value = this.parse(value);
        this.supplier = null;
    }

    public BasicLongHeader(String name, Long value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicLongHeader(String name, Supplier<Long> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify(this.value());
    }

    public Optional<Long> asLong() {
        return CollectionUtils.optional(this.value());
    }

    public Long toLong() {
        return this.value();
    }

    public FluentLongAssertion<BasicLongHeader> assertLong() {
        return new FluentLongAssertion<BasicLongHeader>(this.value(), this);
    }

    public Long orElse(Long other) {
        Long x = this.value();
        return x != null ? x : other;
    }

    private Long parse(String value) {
        try {
            return value == null ? null : Long.valueOf(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw ThrowableUtils.runtimeException("Value ''{0}'' could not be parsed as a long.", value);
        }
    }

    private Long value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

