/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.http.Header;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.HeaderSupplier;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.http.remote.Remote;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.client.remote.RemoteMethodMeta;
import org.apache.juneau.rest.client.remote.RemoteResource;
import org.apache.juneau.svl.VarResolver;

public class RemoteMeta {
    private final Map<Method, RemoteMethodMeta> methods;
    private final HeaderSupplier headerSupplier = HeaderSupplier.create().resolving();

    public RemoteMeta(Class<?> c) {
        String path = "";
        ClassInfo ci = ClassInfo.of(c);
        for (RemoteResource r : ci.getAnnotations(RemoteResource.class)) {
            if (r.path().isEmpty()) continue;
            path = StringUtils.trimSlashes((String)r.path());
        }
        for (RemoteResource r : ci.getAnnotations(org.apache.juneau.http.remote.RemoteResource.class)) {
            if (r.path().isEmpty()) continue;
            path = StringUtils.trimSlashes((String)r.path());
        }
        String versionHeader = "X-Client-Version";
        String clientVersion = null;
        for (Remote r : ci.getAnnotations(Remote.class)) {
            if (!r.path().isEmpty()) {
                path = StringUtils.trimSlashes((String)RemoteMeta.resolve(r.path()));
            }
            for (String h : r.headers()) {
                this.headerSupplier.add((Header)BasicHeader.ofPair((String)RemoteMeta.resolve(h)));
            }
            if (!r.version().isEmpty()) {
                clientVersion = RemoteMeta.resolve(r.version());
            }
            if (!r.versionHeader().isEmpty()) {
                versionHeader = RemoteMeta.resolve(r.versionHeader());
            }
            if (r.headerSupplier() == HeaderSupplier.Null.class) continue;
            try {
                this.headerSupplier.add((HeaderSupplier)r.headerSupplier().newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate HeaderSupplier class.", e);
            }
        }
        if (clientVersion != null) {
            this.headerSupplier.add((Header)BasicStringHeader.of((String)versionHeader, clientVersion));
        }
        AMap methods = AMap.of();
        for (MethodInfo m : ci.getPublicMethods()) {
            methods.put((Object)m.inner(), (Object)new RemoteMethodMeta(path, m.inner(), "GET"));
        }
        this.methods = methods.unmodifiable();
    }

    public RemoteMethodMeta getMethodMeta(Method m) {
        return this.methods.get(m);
    }

    public Iterable<Header> getHeaders() {
        return this.headerSupplier;
    }

    private static String resolve(String s) {
        return VarResolver.DEFAULT.resolve(s);
    }
}

