/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.VarResolverSession;

public class RequestAttributes
extends OMap {
    private static final long serialVersionUID = 1L;
    final RestRequest req;
    final OMap defaultEntries;
    final VarResolverSession vs;

    RequestAttributes(RestRequest req, OMap defaultEntries) {
        this.req = req;
        this.defaultEntries = defaultEntries;
        this.vs = req.getVarResolverSession();
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        String k = key.toString();
        Object o = this.req.getAttribute(k);
        if (o == null) {
            o = this.req.getSession().getAttribute(k);
        }
        if (o == null) {
            o = this.defaultEntries.get((Object)k);
        }
        return this.resolve(o);
    }

    public Object put(String key, Object value) {
        Object o = this.req.getAttribute(key);
        this.req.setAttribute(key, value);
        return o;
    }

    Object resolve(Object o) {
        if (o instanceof CharSequence) {
            o = this.vs.resolve(o.toString());
        }
        return o;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    Set<String> keys = new LinkedHashSet<String>();
                    Iterator<String> keyIterator;
                    Iterator<Map.Entry<String, Object>> defaultsIterator;
                    Map.Entry<String, Object> peekNext;
                    {
                        for (String s : CollectionUtils.iterable((Enumeration)RequestAttributes.this.req.getAttributeNames())) {
                            this.keys.add(s);
                        }
                        for (String s : CollectionUtils.iterable((Enumeration)RequestAttributes.this.req.getSession().getAttributeNames())) {
                            this.keys.add(s);
                        }
                        this.keyIterator = this.keys.iterator();
                        this.defaultsIterator = RequestAttributes.this.defaultEntries.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.keyIterator.hasNext()) {
                            return true;
                        }
                        while (this.defaultsIterator.hasNext() && this.peekNext == null) {
                            this.peekNext = this.defaultsIterator.next();
                            if (!this.keys.contains(this.peekNext.getKey())) continue;
                            this.peekNext = null;
                        }
                        return this.peekNext != null;
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        if (this.keyIterator.hasNext()) {
                            final String k = this.keyIterator.next();
                            return new Map.Entry<String, Object>(){

                                @Override
                                public String getKey() {
                                    return k;
                                }

                                @Override
                                public Object getValue() {
                                    return RequestAttributes.this.resolve(RequestAttributes.this.req.getAttribute(k));
                                }

                                @Override
                                public Object setValue(Object value) {
                                    Object o = RequestAttributes.this.req.getAttribute(k);
                                    RequestAttributes.this.req.setAttribute(k, value);
                                    return o;
                                }
                            };
                        }
                        while (this.defaultsIterator.hasNext() && this.peekNext == null) {
                            this.peekNext = this.defaultsIterator.next();
                            if (!this.keys.contains(this.peekNext.getKey())) continue;
                            this.peekNext = null;
                        }
                        if (this.peekNext != null) {
                            final Map.Entry<String, Object> o = this.peekNext;
                            Map.Entry<String, Object> o2 = new Map.Entry<String, Object>(){

                                @Override
                                public String getKey() {
                                    return (String)o.getKey();
                                }

                                @Override
                                public Object getValue() {
                                    return RequestAttributes.this.resolve(o.getValue());
                                }

                                @Override
                                public Object setValue(Object value) {
                                    Object o3 = o.getValue();
                                    RequestAttributes.this.req.setAttribute((String)o.getKey(), value);
                                    return RequestAttributes.this.resolve(o3);
                                }
                            };
                            this.peekNext = null;
                            return o2;
                        }
                        return null;
                    }
                };
            }

            @Override
            public int size() {
                int i = RequestAttributes.this.defaultEntries.size();
                for (String s : CollectionUtils.iterable((Enumeration)RequestAttributes.this.req.getAttributeNames())) {
                    if (RequestAttributes.this.defaultEntries.containsKey((Object)s)) continue;
                    ++i;
                }
                return i;
            }
        };
    }
}

