/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class UnmodifiableArray<T>
implements List<T> {
    final T[] array;
    final int length;
    private final boolean reversed;

    public UnmodifiableArray(T[] array) {
        this(array, false);
    }

    public UnmodifiableArray(T[] array, boolean reversed) {
        this.array = array == null ? new Object[]{} : array;
        this.length = this.array.length;
        this.reversed = reversed;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.reversed) {
            return new Iterator<T>(){
                int i;
                {
                    this.i = UnmodifiableArray.this.length - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.i > -1;
                }

                @Override
                public T next() {
                    return UnmodifiableArray.this.array[this.i--];
                }
            };
        }
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < UnmodifiableArray.this.length;
            }

            @Override
            public T next() {
                return UnmodifiableArray.this.array[this.i++];
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] o2 = (Object[])Array.newInstance(this.array.getClass().getComponentType(), this.array.length);
        for (int i = 0; i < this.array.length; ++i) {
            o2[i] = this.reversed ? this.array[this.length - i - 1] : this.array[i];
        }
        return o2;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.length) {
            return this.toArray();
        }
        for (int i = 0; i < this.array.length; ++i) {
            a[i] = this.reversed ? this.array[this.length - i - 1] : this.array[i];
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public T get(int index) {
        return this.reversed ? this.array[this.length - index - 1] : this.array[index];
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Cannot modify read-only list.");
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.length; ++i) {
            int j = this.reversed ? this.length - i - 1 : i;
            T t = this.array[j];
            if (o != t && (o == null || !o.equals(t))) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.length - 1; i >= 0; --i) {
            int j = this.reversed ? this.length - i - 1 : i;
            T t = this.array[j];
            if (o != t && (o == null || !o.equals(t))) continue;
            return j;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("Unsupported method on ReadOnlyArrayList class.");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("Unsupported method on ReadOnlyArrayList class.");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (this.reversed) {
            List<T> l = Arrays.asList(this.array);
            Collections.reverse(l);
            return l.subList(fromIndex, toIndex);
        }
        return Arrays.asList(this.array).subList(fromIndex, toIndex);
    }
}

