/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicMediaTypeHeader;
import org.apache.juneau.internal.Cache;

@Header(value="Content-Type")
@BeanIgnore
public class ContentType
extends BasicMediaTypeHeader {
    private static final long serialVersionUID = 1L;
    private static Cache<String, ContentType> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);

    public static ContentType of(String value) {
        if (value == null) {
            return null;
        }
        ContentType ct = CACHE.get(value);
        if (ct == null) {
            ct = CACHE.put(value, new ContentType(value));
        }
        return ct;
    }

    public static ContentType of(MediaType value) {
        if (value == null) {
            return null;
        }
        return ContentType.of(value.toString());
    }

    public static ContentType of(Object value) {
        return new ContentType(value);
    }

    public static ContentType of(Supplier<?> value) {
        return new ContentType(value);
    }

    public ContentType(Object value) {
        super("Content-Type", value);
    }

    public ContentType(String value) {
        this((Object)value);
    }
}

