/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.HLineGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.PathData;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TargetCollectorHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PathGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "animation", "", "getAnimation", "()Ljava/lang/Object;", "setAnimation", "(Ljava/lang/Object;)V", "flat", "", "getFlat", "()Z", "setFlat", "(Z)V", "geodesic", "getGeodesic", "setGeodesic", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "dataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Companion", "plot-base"})
public class PathGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Object animation;
    private boolean flat;
    private boolean geodesic;
    public static final boolean HANDLES_GROUPS = true;

    @Nullable
    public final Object getAnimation() {
        return this.animation;
    }

    public final void setAnimation(@Nullable Object object) {
        this.animation = object;
    }

    public final boolean getFlat() {
        return this.flat;
    }

    public final void setFlat(boolean bl) {
        this.flat = bl;
    }

    public final boolean getGeodesic() {
        return this.geodesic;
    }

    public final void setGeodesic(boolean bl) {
        this.geodesic = bl;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return HLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    @NotNull
    protected Iterable<DataPointAesthetics> dataPoints(@NotNull Aesthetics aesthetics2) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        return GeomUtil.INSTANCE.with_X_Y(aesthetics2.dataPoints());
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable<DataPointAesthetics> dataPoints2 = this.dataPoints(aesthetics2);
        LinesHelper linesHelper = new LinesHelper(pos, coord, ctx);
        if (coord.isLinear() || this.flat) {
            List<List<PathData>> variadicPathData = linesHelper.createVariadicPathData$plot_base(dataPoints2);
            List<PathData> visualPathData = LinesHelper.Companion.createVisualPath(variadicPathData);
            TargetCollectorHelper targetCollectorHelper = new TargetCollectorHelper(GeomKind.PATH, ctx);
            targetCollectorHelper.addVariadicPaths(variadicPathData);
            List<LinePath> svgPath = linesHelper.createPaths$plot_base(visualPathData, false);
            GeomBase.Companion.appendNodes(root, svgPath);
        } else {
            List<List<PathData>> variadicPathData = linesHelper.createVariadicNonLinearPathData$plot_base(dataPoints2);
            List<PathData> visualPathData = LinesHelper.Companion.createVisualPath(variadicPathData);
            List<PathData> smoothed2 = linesHelper.interpolate(visualPathData);
            TargetCollectorHelper targetCollectorHelper = new TargetCollectorHelper(GeomKind.PATH, ctx);
            targetCollectorHelper.addVariadicPaths(variadicPathData);
            List<LinePath> svgPath = linesHelper.createPaths$plot_base(smoothed2, false);
            GeomBase.Companion.appendNodes(root, svgPath);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PathGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

