/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.encoding.RGBEncoder;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.logging.Logger;
import org.jetbrains.letsPlot.commons.logging.PortableLogging;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.config.BunchConfig;
import org.jetbrains.letsPlot.core.spec.config.PlotConfig;
import org.jetbrains.letsPlot.core.util.MonolithicCommon;
import org.jetbrains.letsPlot.core.util.PlotSvgExportCommon;
import org.jetbrains.letsPlot.core.util.PlotSvgHelper;
import org.jetbrains.letsPlot.datamodel.svg.util.SvgToString;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotSvgExportCommon;", "", "()V", "LOG", "Lorg/jetbrains/letsPlot/commons/logging/Logger;", "buildSvgImageFromRawSpecs", "", "plotSpec", "", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "rgbEncoder", "Lorg/jetbrains/letsPlot/commons/encoding/RGBEncoder;", "useCssPixelatedImageRendering", "", "getBunchItemSvgStyle", "svg", "transformBunchItemSvg", "Lkotlin/Pair;", "x", "", "y", "plot-stem"})
public final class PlotSvgExportCommon {
    @NotNull
    public static final PlotSvgExportCommon INSTANCE = new PlotSvgExportCommon();
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(PlotSvgExportCommon.class));

    private PlotSvgExportCommon() {
    }

    @NotNull
    public final String buildSvgImageFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @NotNull RGBEncoder rgbEncoder, boolean useCssPixelatedImageRendering) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)rgbEncoder, (String)"rgbEncoder");
        SvgToString svgToString = new SvgToString(rgbEncoder, useCssPixelatedImageRendering);
        List<String> list2 = MonolithicCommon.INSTANCE.buildSvgImagesFromRawSpecs(plotSpec, plotSize2, svgToString, (Function1<? super List<String>, Unit>)((Function1)buildSvgImageFromRawSpecs.list.1.INSTANCE));
        if (list2.isEmpty()) {
            throw new IllegalStateException("Nothing to save: the plot is empty.");
        }
        if (list2.size() == 1) {
            return list2.get(0);
        }
        if (PlotConfig.Companion.figSpecKind(plotSpec) != FigKind.GG_BUNCH_SPEC) {
            throw new IllegalStateException("Can't save multiple SVG images in one file.");
        }
        ArrayList<String> bunchItemSvgList = new ArrayList<String>();
        DoubleRectangle bunchBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        List<BunchConfig.BunchItem> bunchItems = new BunchConfig(plotSpec).getBunchItems();
        for (Pair pair : CollectionsKt.zip((Iterable)list2, (Iterable)bunchItems)) {
            String plotSvg = (String)pair.component1();
            BunchConfig.BunchItem bunchItem = (BunchConfig.BunchItem)pair.component2();
            Pair<String, DoubleVector> pair2 = this.transformBunchItemSvg(plotSvg, bunchItem.getX(), bunchItem.getY());
            String itemSvg = (String)pair2.component1();
            DoubleVector size = (DoubleVector)pair2.component2();
            bunchItemSvgList.add(itemSvg);
            bunchBounds = bunchBounds.union(new DoubleRectangle(bunchItem.getX(), bunchItem.getY(), size.getX(), size.getY()));
        }
        String svgStyle2 = StringsKt.trimMargin$default((String)(" \n            |<style type=\"text/css\">\n            |" + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((Object)INSTANCE){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return PlotSvgExportCommon.access$getBunchItemSvgStyle((PlotSvgExportCommon)this.receiver, p0);
            }
        }), (int)30, null) + "\n            |</style>\n        "), null, (int)1, null);
        return StringsKt.trimMargin$default((String)("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" class=\"plt-container\" width=\"" + bunchBounds.getWidth() + "\" height=\"" + bunchBounds.getHeight() + "\">\n            |" + svgStyle2 + "\n            |" + CollectionsKt.joinToString$default((Iterable)bunchItemSvgList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n            |</svg>\n        "), null, (int)1, null);
    }

    public static /* synthetic */ String buildSvgImageFromRawSpecs$default(PlotSvgExportCommon plotSvgExportCommon, Map map2, DoubleVector doubleVector, RGBEncoder rGBEncoder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            doubleVector = null;
        }
        return plotSvgExportCommon.buildSvgImageFromRawSpecs(map2, doubleVector, rGBEncoder, bl);
    }

    private final String getBunchItemSvgStyle(String svg) {
        String[] stringArray = new String[]{"<style type=\"text/css\">"};
        List split = StringsKt.split$default((CharSequence)svg, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String styleAtTheTop = (String)split.get(1);
        String[] stringArray2 = new String[]{"</style>"};
        return (String)StringsKt.split$default((CharSequence)styleAtTheTop, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(0);
    }

    private final Pair<String, DoubleVector> transformBunchItemSvg(String svg, double x, double y) {
        String[] stringArray = new String[]{"</style>"};
        List split = StringsKt.split$default((CharSequence)svg, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = new String[]{"</svg>"};
        String rootGroup = (String)StringsKt.split$default((CharSequence)((CharSequence)split.get(1)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(0);
        StringBuilder stringBuilder = new StringBuilder().append("<g transform=\"translate(").append(x).append(' ').append(y).append(")\" ");
        String string = rootGroup.substring(StringsKt.indexOf$default((CharSequence)rootGroup, (String)"<g ", (int)0, (boolean)false, (int)6, null) + 3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String rootGroupTranslated = stringBuilder.append(string).toString();
        DoubleVector svgSize = PlotSvgHelper.INSTANCE.fetchPlotSizeFromSvg(svg);
        return new Pair((Object)rootGroupTranslated, (Object)svgSize);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$getBunchItemSvgStyle(PlotSvgExportCommon $this, String svg) {
        return $this.getBunchItemSvgStyle(svg);
    }
}

