/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.DarkSVGIcon;
import com.github.weisj.darklaf.icons.IconColorMapper;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.icons.ThemedIcon;
import java.net.URI;
import java.util.function.Supplier;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class ThemedSVGIcon
extends DarkSVGIcon
implements ThemedIcon {
    private Object currentTheme;
    private boolean updatedNotDuringPaint;

    public ThemedSVGIcon(Supplier<URI> uriSupplier, int displayWidth, int displayHeight) {
        super(uriSupplier, displayWidth, displayHeight);
        this.currentTheme = new Object();
    }

    public ThemedSVGIcon(URI uri, int displayWidth, int displayHeight) {
        super(uri, displayWidth, displayHeight);
        this.currentTheme = new Object();
    }

    protected ThemedSVGIcon(int width, int height, ThemedSVGIcon icon) {
        super(width, height, icon);
        this.currentTheme = icon.currentTheme;
        this.updatedNotDuringPaint = icon.updatedNotDuringPaint;
    }

    @Override
    public ThemedSVGIcon derive(int width, int height) {
        if (width == this.getIconWidth() && height == this.getIconHeight()) {
            return this;
        }
        return new ThemedSVGIcon(width, height, this);
    }

    @Override
    protected boolean ensureLoaded(boolean painting) {
        return super.ensureLoaded(painting) | this.ensureTheme(painting);
    }

    protected boolean ensureTheme(boolean painting) {
        Object theme = IconLoader.getThemeStatus();
        if (this.currentTheme != theme) {
            this.patchColors();
            this.currentTheme = theme;
            this.updatedNotDuringPaint = !painting;
            return true;
        }
        if (this.updatedNotDuringPaint) {
            this.updatedNotDuringPaint = false;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "ThemedSVGIcon{parentState= " + super.toString() + "currentTheme=" + this.currentTheme + ", updatedNotDuringPaint=" + this.updatedNotDuringPaint + '}';
    }

    protected void invalidate() {
        this.currentTheme = new Object();
    }

    protected UIDefaults getContextDefaults() {
        return UIManager.getDefaults();
    }

    protected void patchColors() {
        IconColorMapper.patchColors(this.getSVGIcon(), this.getContextDefaults());
    }
}

