/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import jodd.lagarto.EmptyTagVisitor;
import jodd.lagarto.LagartoException;
import jodd.lagarto.LagartoParser;
import jodd.lagarto.LagartoParserConfig;
import jodd.lagarto.Tag;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.dom.HtmlCCommentExpressionMatcher;
import jodd.lagarto.dom.LagartoDomBuilderConfig;
import jodd.log.LoggerFactory;
import jodd.log.LoggerProvider;
import jodd.log.impl.Slf4jLogger;
import jodd.util.CharSequenceUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.HTMLParser;
import org.apache.jmeter.protocol.http.parser.HtmlParsingUtils;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.slf4j.Logger;

public class LagartoBasedHtmlParser
extends HTMLParser {
    private static final Logger log = org.slf4j.LoggerFactory.getLogger(LagartoBasedHtmlParser.class);

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] html, URL baseUrl, URLCollection coll, String encoding) throws HTMLParseException {
        try {
            Float ieVersion = this.extractIEVersion(userAgent);
            String contents = new String(html, encoding);
            LagartoParser lagartoParser = new LagartoParser(contents.toCharArray());
            LagartoDomBuilderConfig config = new LagartoDomBuilderConfig();
            config.setCaseSensitive(false);
            config.setEnableConditionalComments(LagartoBasedHtmlParser.isEnableConditionalComments(ieVersion));
            if (ieVersion != null) {
                config.setCondCommentIEVersion(ieVersion.floatValue());
            }
            lagartoParser.setConfig((LagartoParserConfig)config);
            JMeterTagVisitor tagVisitor = new JMeterTagVisitor(new URLPointer(baseUrl), coll, ieVersion);
            lagartoParser.parse((TagVisitor)tagVisitor);
            return coll.iterator();
        }
        catch (LagartoException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error extracting embedded resource URLs from:'{}', probably not text content, message:{}", (Object)baseUrl, (Object)e.getMessage());
            }
            return Collections.emptyList().iterator();
        }
        catch (Exception e) {
            throw new HTMLParseException(e);
        }
    }

    static {
        LoggerFactory.setLoggerProvider((LoggerProvider)Slf4jLogger.PROVIDER);
    }

    private static final class JMeterTagVisitor
    extends EmptyTagVisitor {
        private HtmlCCommentExpressionMatcher htmlCCommentExpressionMatcher;
        private final URLCollection urls;
        private final URLPointer baseUrl;
        private final Float ieVersion;
        private final Deque<Boolean> enabled = new ArrayDeque<Boolean>();

        public JMeterTagVisitor(URLPointer baseUrl, URLCollection urls, Float ieVersion) {
            this.urls = urls;
            this.baseUrl = baseUrl;
            this.ieVersion = ieVersion;
        }

        private void extractAttribute(Tag tag, String attributeName) {
            CharSequence url = tag.getAttributeValue((CharSequence)attributeName);
            String normalizedUrl = HTMLParser.normalizeUrlValue(url);
            if (normalizedUrl != null) {
                this.urls.addURL(normalizedUrl, this.baseUrl.url);
            }
        }

        public void script(Tag tag, CharSequence body) {
            if (!this.enabled.peek().booleanValue()) {
                return;
            }
            this.extractAttribute(tag, "src");
        }

        /*
         * Unable to fully structure code
         */
        public void tag(Tag tag) {
            if (!this.enabled.peek().booleanValue()) {
                return;
            }
            tagType = tag.getType();
            switch (1.$SwitchMap$jodd$lagarto$TagType[tagType.ordinal()]) {
                case 1: 
                case 2: {
                    if (tag.nameEquals((CharSequence)"body")) {
                        this.extractAttribute(tag, "background");
                    } else if (tag.nameEquals((CharSequence)"base")) {
                        baseref = tag.getAttributeValue((CharSequence)"href");
                        try {
                            if (StringUtils.isEmpty((CharSequence)baseref)) ** GOTO lbl59
                            URLPointer.access$002(this.baseUrl, ConversionUtils.makeRelativeURL(URLPointer.access$000(this.baseUrl), baseref.toString()));
                        }
                        catch (MalformedURLException e1) {
                            throw new IllegalArgumentException("Error creating relative url from " + baseref, e1);
                        }
                    } else if (tag.nameEquals((CharSequence)"img")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"applet")) {
                        codebase = tag.getAttributeValue((CharSequence)"codebase");
                        archive = tag.getAttributeValue((CharSequence)"archive");
                        code = tag.getAttributeValue((CharSequence)"code");
                        if (StringUtils.isNotBlank((CharSequence)codebase)) {
                            result = StringUtils.isNotBlank((CharSequence)archive) != false ? codebase.toString() + "/" + archive : codebase.toString() + "/" + code;
                            this.urls.addURL(HTMLParser.normalizeUrlValue(result), URLPointer.access$000(this.baseUrl));
                        } else {
                            this.extractAttribute(tag, "code");
                        }
                    } else if (tag.nameEquals((CharSequence)"object")) {
                        this.extractAttribute(tag, "codebase");
                        this.extractAttribute(tag, "data");
                    } else if (tag.nameEquals((CharSequence)"input")) {
                        type = tag.getAttributeValue((CharSequence)"type");
                        if (type != null && CharSequenceUtil.equalsIgnoreCase((CharSequence)"image", (CharSequence)type)) {
                            this.extractAttribute(tag, "src");
                        }
                    } else if (tag.nameEquals((CharSequence)"script")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"frame") || tag.nameEquals((CharSequence)"iframe")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"embed")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"bgsound")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"link")) {
                        relAttribute = tag.getAttributeValue((CharSequence)"rel");
                        if (relAttribute != null && (CharSequenceUtil.equalsIgnoreCase((CharSequence)"stylesheet", (CharSequence)relAttribute) || CharSequenceUtil.equalsIgnoreCase((CharSequence)"icon", (CharSequence)relAttribute) || CharSequenceUtil.equalsIgnoreCase((CharSequence)"shortcut icon", (CharSequence)relAttribute) || CharSequenceUtil.equalsIgnoreCase((CharSequence)"preload", (CharSequence)relAttribute))) {
                            this.extractAttribute(tag, "href");
                        }
                    } else {
                        this.extractAttribute(tag, "background");
                    }
lbl59:
                    // 14 sources

                    styleTagStr = tag.getAttributeValue((CharSequence)"style");
                    if (StringUtils.isEmpty((CharSequence)styleTagStr)) break;
                    HtmlParsingUtils.extractStyleURLs(URLPointer.access$000(this.baseUrl), this.urls, styleTagStr.toString());
                    break;
                }
            }
        }

        public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, boolean isHiddenEndTag) {
            if (!isStartingTag) {
                this.enabled.pop();
            } else {
                if (this.htmlCCommentExpressionMatcher == null) {
                    this.htmlCCommentExpressionMatcher = new HtmlCCommentExpressionMatcher();
                }
                String expressionString = expression.toString().trim();
                this.enabled.push(this.htmlCCommentExpressionMatcher.match(this.ieVersion.floatValue(), expressionString));
            }
        }

        public void start() {
            super.start();
            this.enabled.clear();
            this.enabled.push(Boolean.TRUE);
        }
    }

    private static class URLPointer {
        private URL url;

        private URLPointer(URL newUrl) {
            this.url = newUrl;
        }

        static /* synthetic */ URL access$002(URLPointer x0, URL x1) {
            x0.url = x1;
            return x0.url;
        }
    }
}

