/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.bistro.residual;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.bistro.residual.Model;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfo;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfoFactory;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfoImpl;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.LinearRegression;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.LocalPolynomialRegression;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.PolynomialRegression;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.RegressionEvaluator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000eH\u0002J4\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000eH\u0002J2\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/bistro/residual/Model;", "", "method", "Lorg/jetbrains/letsPlot/bistro/residual/Model$Method;", "polynomialDegree", "", "span", "", "(Lorg/jetbrains/letsPlot/bistro/residual/Model$Method;ID)V", "getMethod", "()Lorg/jetbrains/letsPlot/bistro/residual/Model$Method;", "getLMPredictor", "Lkotlin/Function1;", "xs", "", "ys", "getLoessPredictor", "getPredictor", "Companion", "Method", "plot-api"})
@SourceDebugExtension(value={"SMAP\nModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Model.kt\norg/jetbrains/letsPlot/bistro/residual/Model\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class Model {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Method method;
    private final int polynomialDegree;
    private final double span;
    @NotNull
    private static final Method METHOD_DEF = Method.LM;
    public static final int POLYNOMIAL_DEGREE_DEF = 1;
    public static final double SPAN_DEF = 0.5;
    public static final double CONFIDENCE_LEVEL = 0.95;

    public Model(@NotNull Method method, int polynomialDegree, double span) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.method = method;
        this.polynomialDegree = polynomialDegree;
        this.span = span;
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final Function1<Double, Double> getPredictor(@NotNull List<Double> xs, @NotNull List<Double> ys) {
        Function1<Double, Double> function1;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
            case 1: {
                function1 = this.getLMPredictor(xs, ys);
                break;
            }
            case 2: 
            case 3: {
                function1 = this.getLoessPredictor(xs, ys);
                break;
            }
            case 4: {
                function1 = getPredictor.1.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function1;
    }

    private final Function1<Double, Double> getLMPredictor(List<Double> xs, List<Double> ys) {
        if (!(this.polynomialDegree >= 1)) {
            boolean bl = false;
            String string = "Degree of polynomial regression must be at least 1";
            throw new IllegalArgumentException(string.toString());
        }
        RegressionEvaluator regression = this.polynomialDegree == 1 ? (RegressionEvaluator)LinearRegression.Companion.fit(xs, ys, 0.95) : (RegressionEvaluator)PolynomialRegression.Companion.fit(xs, ys, 0.95, this.polynomialDegree);
        if (!(regression != null)) {
            boolean bl = false;
            String string = this.polynomialDegree == 1 ? "Too small dataset for the linear regression" : "Degree of polynomial is too big for the given data";
            throw new IllegalArgumentException(string.toString());
        }
        return (Function1)new Function1<Double, Double>(regression){
            final /* synthetic */ RegressionEvaluator $regression;
            {
                this.$regression = $regression;
                super(1);
            }

            @NotNull
            public final Double invoke(double x) {
                return this.$regression.evalX(x).getY();
            }
        };
    }

    private final Function1<Double, Double> getLoessPredictor(List<Double> xs, List<Double> ys) {
        LocalPolynomialRegression regression = LocalPolynomialRegression.Companion.fit(xs, ys, 0.95, this.span);
        if (!(regression != null)) {
            boolean bl = false;
            String string = "Too small dataset for the loess method";
            throw new IllegalArgumentException(string.toString());
        }
        return (Function1)new Function1<Double, Double>(regression){
            final /* synthetic */ LocalPolynomialRegression $regression;
            {
                this.$regression = $regression;
                super(1);
            }

            @NotNull
            public final Double invoke(double x) {
                return this.$regression.evalX(x).getY();
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/bistro/residual/Model$Companion;", "", "()V", "CONFIDENCE_LEVEL", "", "METHOD_DEF", "Lorg/jetbrains/letsPlot/bistro/residual/Model$Method;", "getMETHOD_DEF", "()Lorg/jetbrains/letsPlot/bistro/residual/Model$Method;", "POLYNOMIAL_DEGREE_DEF", "", "SPAN_DEF", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Method getMETHOD_DEF() {
            return METHOD_DEF;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/bistro/residual/Model$Method;", "", "(Ljava/lang/String;I)V", "LM", "LOESS", "LOWESS", "NONE", "Companion", "plot-api"})
    @SourceDebugExtension(value={"SMAP\nModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Model.kt\norg/jetbrains/letsPlot/bistro/residual/Model$Method\n+ 2 EnumInfoFactory.kt\norg/jetbrains/letsPlot/core/commons/enums/EnumInfoFactory\n*L\n1#1,70:1\n14#2:71\n*S KotlinDebug\n*F\n+ 1 Model.kt\norg/jetbrains/letsPlot/bistro/residual/Model$Method\n*L\n52#1:71\n*E\n"})
    public static final class Method
    extends Enum<Method> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final EnumInfo<Method> ENUM_INFO;
        public static final /* enum */ Method LM;
        public static final /* enum */ Method LOESS;
        public static final /* enum */ Method LOWESS;
        public static final /* enum */ Method NONE;
        private static final /* synthetic */ Method[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        @NotNull
        public static EnumEntries<Method> getEntries() {
            return $ENTRIES;
        }

        static {
            LM = new Method();
            LOESS = new Method();
            LOWESS = new Method();
            NONE = new Method();
            $VALUES = methodArray = new Method[]{Method.LM, Method.LOESS, Method.LOWESS, Method.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            EnumInfoFactory this_$iv = EnumInfoFactory.INSTANCE;
            boolean $i$f$createEnumInfo = false;
            ENUM_INFO = (EnumInfo)new EnumInfoImpl((Enum[])Method.values());
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/bistro/residual/Model$Method$Companion;", "", "()V", "ENUM_INFO", "Lorg/jetbrains/letsPlot/core/commons/enums/EnumInfo;", "Lorg/jetbrains/letsPlot/bistro/residual/Model$Method;", "safeValueOf", "v", "", "plot-api"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Method safeValueOf(@NotNull String v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Method method = (Method)ENUM_INFO.safeValueOf(v);
                if (method == null) {
                    throw new IllegalArgumentException("Unsupported method: '" + v + "'\nUse one of: lm, loess, lowess, none.");
                }
                return method;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.LM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.LOESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.LOWESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

