/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.popupmenu;

import com.github.weisj.darklaf.ui.popupmenu.MouseGrabber;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentListener;
import java.awt.event.WindowListener;
import java.security.AccessController;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeListener;

public final class MouseGrabberUtil {
    private static MouseGrabber mouseGrabber;

    private MouseGrabberUtil() {
    }

    public static void uninstallMouseGrabber() {
        if (mouseGrabber != null) {
            mouseGrabber.uninstall();
            mouseGrabber = null;
        }
    }

    public static void installMouseGrabber() {
        if (mouseGrabber == null) {
            MouseGrabberUtil.uninstallOldMouseGrabber(MouseGrabberUtil.getOldMouseGrabber());
            mouseGrabber = new MouseGrabber();
            mouseGrabber.install();
        }
    }

    private static ChangeListener getOldMouseGrabber() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        for (ChangeListener listener : menuSelectionManager.getChangeListeners()) {
            Class<?> enclosingClass;
            Class<?> listenerClass;
            if (listener == null || (listenerClass = listener.getClass()) == null || (enclosingClass = listenerClass.getEnclosingClass()) == null || !listenerClass.getName().endsWith("MouseGrabber") || !enclosingClass.getName().endsWith("BasicPopupMenuUI")) continue;
            return listener;
        }
        return null;
    }

    private static void uninstallOldMouseGrabber(ChangeListener oldMouseGrabber) {
        MenuElement[] path;
        if (oldMouseGrabber == null) {
            return;
        }
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        menuSelectionManager.removeChangeListener(oldMouseGrabber);
        if (oldMouseGrabber instanceof AWTEventListener) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(() -> {
                tk.removeAWTEventListener((AWTEventListener)((Object)oldMouseGrabber));
                return null;
            });
        }
        if ((path = menuSelectionManager.getSelectedPath()).length != 0 && path[0] != null) {
            Component invoker = path[0].getComponent();
            if (invoker instanceof JPopupMenu) {
                invoker = ((JPopupMenu)invoker).getInvoker();
            }
            Window grabbedWindow = DarkUIUtil.getWindow(invoker);
            if (oldMouseGrabber instanceof WindowListener) {
                grabbedWindow.removeWindowListener((WindowListener)((Object)oldMouseGrabber));
            }
            if (oldMouseGrabber instanceof ComponentListener) {
                grabbedWindow.removeComponentListener((ComponentListener)((Object)oldMouseGrabber));
            }
        }
    }
}

