/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.listener;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.MouseInputListener;

public class MouseInputDelegate
implements MouseInputListener {
    protected MouseListener mouseDelegate;
    protected MouseMotionListener motionDelegate;

    public MouseInputDelegate(MouseListener mouseListener) {
        this(mouseListener, null);
    }

    public MouseInputDelegate(MouseMotionListener motionDelegate) {
        this(null, motionDelegate);
    }

    public MouseInputDelegate(MouseListener mouseListener, MouseMotionListener motionDelegate) {
        this.setMotionDelegate(motionDelegate);
        this.setMouseDelegate(mouseListener);
    }

    public MouseInputDelegate(MouseInputListener delegate) {
        this(delegate, delegate);
    }

    public MouseListener getMouseDelegate() {
        return this.mouseDelegate;
    }

    public MouseMotionListener getMotionDelegate() {
        return this.motionDelegate;
    }

    public void setMotionDelegate(MouseMotionListener motionDelegate) {
        this.motionDelegate = motionDelegate;
        if (motionDelegate == null) {
            this.motionDelegate = new MouseAdapter(){};
        }
    }

    public void setMouseDelegate(MouseListener delegate) {
        this.mouseDelegate = delegate;
        if (delegate == null) {
            this.mouseDelegate = new MouseAdapter(){};
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.getMouseDelegate().mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.getMouseDelegate().mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.getMouseDelegate().mousePressed(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.getMouseDelegate().mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.getMouseDelegate().mouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.getMotionDelegate().mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.getMotionDelegate().mouseMoved(e);
    }
}

