/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.Geom;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.geom.PointDimensionsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.util.YOrientationAesthetics;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.PlotUtil;
import org.jetbrains.letsPlot.core.plot.builder.assemble.GeomContextBuilder;
import org.jetbrains.letsPlot.core.plot.builder.assemble.ImmutableGeomContext;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062#\u0010\u0007\u001a\u001f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\u00040\bH\u0002J(\u0010\r\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J0\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u0015\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e0\u00172\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ:\u0010\u001e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0002JP\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u001a2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00172\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\u00172\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006+"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PositionalScalesUtil;", "", "()V", "computeLayerDryRunRangeAfterSizeExpand", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pointSpan", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lkotlin/ParameterName;", "name", "p", "computeLayerDryRunXYRanges", "Lkotlin/Pair;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "computeLayerDryRunXYRangesAfterPosAdjustment", "aes", "geomCtx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "computeLayerDryRunXYRangesAfterSizeExpand", "computePlotXYTransformedDomains", "", "layersByTile", "xScaleProto", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "yScaleProto", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "computeTileXYDomains", "layers", "xInitialDomain", "yInitialDomain", "finalizeDomains", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "", "scaleProto", "domains", "freeScale", "", "positionalDryRunAesthetics", "RangeUtil", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPositionalScalesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionalScalesUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PositionalScalesUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n1559#2:417\n1590#2,4:418\n2730#2,7:422\n1549#2:429\n1620#2,3:430\n2730#2,7:433\n1549#2:440\n1620#2,3:441\n1271#2,2:444\n1285#2,4:446\n766#2:450\n857#2,2:451\n1271#2,2:453\n1285#2,4:455\n*S KotlinDebug\n*F\n+ 1 PositionalScalesUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PositionalScalesUtil\n*L\n84#1:417\n84#1:418,4\n93#1:422,7\n97#1:429\n97#1:430,3\n98#1:433,7\n104#1:440\n104#1:441,3\n114#1:444,2\n114#1:446,4\n138#1:450\n138#1:451,2\n145#1:453,2\n145#1:455,4\n*E\n"})
public final class PositionalScalesUtil {
    @NotNull
    public static final PositionalScalesUtil INSTANCE = new PositionalScalesUtil();

    private PositionalScalesUtil() {
    }

    @NotNull
    public final List<Pair<DoubleSpan, DoubleSpan>> computePlotXYTransformedDomains(@NotNull List<? extends List<? extends GeomLayer>> layersByTile, @NotNull Scale xScaleProto, @NotNull Scale yScaleProto, @NotNull PlotFacets facets) {
        Intrinsics.checkNotNullParameter(layersByTile, (String)"layersByTile");
        Intrinsics.checkNotNullParameter((Object)xScaleProto, (String)"xScaleProto");
        Intrinsics.checkNotNullParameter((Object)yScaleProto, (String)"yScaleProto");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        DoubleSpan xInitialDomain = RangeUtil.INSTANCE.initialRange(xScaleProto.getTransform());
        DoubleSpan yInitialDomain = RangeUtil.INSTANCE.initialRange(yScaleProto.getTransform());
        ArrayList<DoubleSpan> xDomains = new ArrayList<DoubleSpan>();
        ArrayList<DoubleSpan> yDomains = new ArrayList<DoubleSpan>();
        for (List<? extends GeomLayer> list : layersByTile) {
            Pair<DoubleSpan, DoubleSpan> pair = this.computeTileXYDomains(list, xInitialDomain, yInitialDomain);
            DoubleSpan xDomain = (DoubleSpan)pair.component1();
            DoubleSpan yDomain = (DoubleSpan)pair.component2();
            xDomains.add(xDomain);
            yDomains.add(yDomain);
        }
        List<DoubleSpan> adjustedXDomains = facets.adjustHDomains((List<DoubleSpan>)xDomains);
        List<DoubleSpan> list = facets.adjustVDomains((List<DoubleSpan>)yDomains);
        List<DoubleSpan> finalizedXDomains = this.finalizeDomains((Aes<Double>)Aes.Companion.getX(), xScaleProto, adjustedXDomains, layersByTile, facets.getFreeHScale());
        List<DoubleSpan> finalizedYDomains = this.finalizeDomains((Aes<Double>)Aes.Companion.getY(), yScaleProto, list, layersByTile, facets.getFreeVScale());
        return CollectionsKt.zip((Iterable)finalizedXDomains, (Iterable)finalizedYDomains);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DoubleSpan> finalizeDomains(Aes<Double> aes, Scale scaleProto, List<DoubleSpan> domains, List<? extends List<? extends GeomLayer>> layersByTile, boolean freeScale) {
        List list;
        if (freeScale) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = domains;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void v;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DoubleSpan doubleSpan = (DoubleSpan)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DoubleSpan domainExpanded = RangeUtil.INSTANCE.expandRange$plot_builder((DoubleSpan)v, aes, scaleProto, layersByTile.get((int)i));
                collection.add(SeriesUtil.ensureApplicableRange$default((SeriesUtil)SeriesUtil.INSTANCE, (DoubleSpan)domainExpanded, null, (int)2, null));
            }
            list = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv;
            Object v2;
            void $this$reduceOrNull$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Object accumulator$iv;
            Object v1;
            Iterable $this$reduceOrNull$iv2 = CollectionsKt.filterNotNull((Iterable)domains);
            boolean $i$f$reduceOrNull22 = false;
            Iterator iterator$iv = $this$reduceOrNull$iv2.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void r1;
                    DoubleSpan index$iv$iv = (DoubleSpan)iterator$iv.next();
                    DoubleSpan r0 = (DoubleSpan)accumulator$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)RangeUtil.INSTANCE.updateRange$plot_builder(r0, (DoubleSpan)r1));
                }
                v1 = accumulator$iv;
            }
            DoubleSpan domainOverall = v1;
            Iterable $i$f$reduceOrNull22 = layersByTile.get(0);
            boolean $i$f$map = false;
            accumulator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                GeomLayer v = (GeomLayer)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.preferableNullDomain(aes));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduceOrNull = false;
            Iterator iterator$iv2 = $this$reduceOrNull$iv.iterator();
            if (!iterator$iv2.hasNext()) {
                v2 = null;
            } else {
                Object accumulator$iv2 = iterator$iv2.next();
                while (iterator$iv2.hasNext()) {
                    void r1;
                    DoubleSpan $i$f$mapTo2 = (DoubleSpan)iterator$iv2.next();
                    DoubleSpan r0 = (DoubleSpan)accumulator$iv2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)RangeUtil.INSTANCE.updateRange$plot_builder(r0, (DoubleSpan)r1));
                }
                v2 = accumulator$iv2;
            }
            DoubleSpan preferableNullDomainOverall = v2;
            DoubleSpan domainExpanded = RangeUtil.INSTANCE.expandRange$plot_builder(domainOverall, aes, scaleProto, layersByTile.get(0));
            DoubleSpan domain = SeriesUtil.INSTANCE.ensureApplicableRange(domainExpanded, preferableNullDomainOverall);
            Iterable $this$map$iv2 = layersByTile;
            boolean $i$f$map2 = false;
            Iterable r1 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List bl = (List)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(domain);
            }
            list = (List)destination$iv$iv2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<DoubleSpan, DoubleSpan> computeTileXYDomains(List<? extends GeomLayer> layers, DoubleSpan xInitialDomain, DoubleSpan yInitialDomain) {
        Iterable $this$associateWith$iv = layers;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            GeomLayer geomLayer = (GeomLayer)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Aesthetics aesthetics = INSTANCE.positionalDryRunAesthetics((GeomLayer)it);
            map2.put(t, aesthetics);
        }
        Map positionaDryRunAestheticsByLayer = result$iv;
        DoubleSpan xDomainOverall = null;
        DoubleSpan yDomainOverall = null;
        for (Map.Entry entry : positionaDryRunAestheticsByLayer.entrySet()) {
            GeomLayer layer = (GeomLayer)entry.getKey();
            Aesthetics aesthetics = (Aesthetics)entry.getValue();
            Pair<DoubleSpan, DoubleSpan> xyRanges = this.computeLayerDryRunXYRanges(layer, aesthetics);
            DoubleSpan xRangeLayer = RangeUtil.INSTANCE.updateRange$plot_builder(xInitialDomain, (DoubleSpan)xyRanges.getFirst());
            DoubleSpan yRangeLayer = RangeUtil.INSTANCE.updateRange$plot_builder(yInitialDomain, (DoubleSpan)xyRanges.getSecond());
            xDomainOverall = RangeUtil.INSTANCE.updateRange$plot_builder(xRangeLayer, xDomainOverall);
            yDomainOverall = RangeUtil.INSTANCE.updateRange$plot_builder(yRangeLayer, yDomainOverall);
        }
        return new Pair(xDomainOverall, yDomainOverall);
    }

    /*
     * WARNING - void declaration
     */
    private final Aesthetics positionalDryRunAesthetics(GeomLayer layer) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = layer.renderedAes(true);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Aes it = (Aes)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Aes.Companion.affectingScaleX(it) || Aes.Companion.affectingScaleY(it) || Intrinsics.areEqual((Object)it, (Object)Aes.Companion.getHEIGHT()) || Intrinsics.areEqual((Object)it, (Object)Aes.Companion.getWIDTH());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List aesList = (List)destination$iv$iv;
        Iterable $this$associateWith$iv = aesList;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Aes bl = (Aes)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl3 = false;
            ScaleMapper scaleMapper2 = Mappers.INSTANCE.getIDENTITY();
            map2.put(t, scaleMapper2);
        }
        Map mappers = result$iv;
        return PlotUtil.INSTANCE.createLayerAesthetics$plot_builder(layer, aesList, mappers);
    }

    private final Pair<DoubleSpan, DoubleSpan> computeLayerDryRunXYRanges(GeomLayer layer, Aesthetics aesthetics) {
        Pair pair;
        Aesthetics aesthetics2;
        boolean bl = layer.isYOrientation();
        if (bl) {
            aesthetics2 = (Aesthetics)new YOrientationAesthetics(aesthetics);
        } else if (!bl) {
            aesthetics2 = aesthetics;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Aesthetics aesthetics3 = aesthetics2;
        boolean bl2 = false;
        ImmutableGeomContext geomCtx = new GeomContextBuilder().aesthetics(aesthetics3).build();
        Pair rangesXY = INSTANCE.computeLayerDryRunXYRangesAfterPosAdjustment(layer, aesthetics3, geomCtx);
        boolean bl3 = layer.isYOrientation();
        if (bl3) {
            pair = new Pair(rangesXY.getSecond(), rangesXY.getFirst());
        } else if (!bl3) {
            pair = rangesXY;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair rangesAfterPosAdjustment = pair;
        ImmutableGeomContext geomCtx2 = new GeomContextBuilder().aesthetics(aesthetics).build();
        Pair<DoubleSpan, DoubleSpan> pair2 = this.computeLayerDryRunXYRangesAfterSizeExpand(layer, aesthetics, geomCtx2);
        DoubleSpan xRangeAfterSizeExpand = (DoubleSpan)pair2.component1();
        DoubleSpan yRangeAfterSizeExpand = (DoubleSpan)pair2.component2();
        DoubleSpan rangeX = (DoubleSpan)rangesAfterPosAdjustment.getFirst();
        if (rangeX == null) {
            rangeX = xRangeAfterSizeExpand;
        } else if (xRangeAfterSizeExpand != null) {
            rangeX = rangeX.union(xRangeAfterSizeExpand);
        }
        DoubleSpan rangeY = (DoubleSpan)rangesAfterPosAdjustment.getSecond();
        if (rangeY == null) {
            rangeY = yRangeAfterSizeExpand;
        } else if (yRangeAfterSizeExpand != null) {
            rangeY = rangeY.union(yRangeAfterSizeExpand);
        }
        return new Pair((Object)rangeX, (Object)rangeY);
    }

    private final Pair<DoubleSpan, DoubleSpan> computeLayerDryRunXYRangesAfterPosAdjustment(GeomLayer layer, Aesthetics aes, GeomContext geomCtx) {
        List posAesX = Aes.Companion.affectingScaleX((Iterable)GeomLayer.DefaultImpls.renderedAes$default(layer, false, 1, null));
        List posAesY = Aes.Companion.affectingScaleY((Iterable)GeomLayer.DefaultImpls.renderedAes$default(layer, false, 1, null));
        PositionAdjustment pos = PlotUtil.INSTANCE.createPositionAdjustment$plot_builder(layer.getPosProvider(), aes);
        if (pos.isIdentity()) {
            DoubleSpan rangeX = RangeUtil.INSTANCE.combineRanges$plot_builder(posAesX, aes);
            DoubleSpan rangeY = RangeUtil.INSTANCE.combineRanges$plot_builder(posAesY, aes);
            return new Pair((Object)rangeX, (Object)rangeY);
        }
        double adjustedMinX = 0.0;
        double adjustedMaxX = 0.0;
        double adjustedMinY = 0.0;
        double adjustedMaxY = 0.0;
        boolean rangesInited = false;
        int cardinality = posAesX.size() * posAesY.size();
        Double[] px = new Double[cardinality];
        Double[] py = new Double[cardinality];
        for (DataPointAesthetics p : aes.dataPoints()) {
            int i = -1;
            for (Aes aesX : posAesX) {
                Double valX = p.numeric(aesX);
                for (Aes aesY : posAesY) {
                    Double valY = p.numeric(aesY);
                    px[++i] = valX;
                    py[i] = valY;
                }
            }
            while (i >= 0) {
                if (px[i] != null && py[i] != null) {
                    Double x = px[i];
                    Double y = py[i];
                    if (SeriesUtil.INSTANCE.isFinite(x) && SeriesUtil.INSTANCE.isFinite(y)) {
                        Double d = x;
                        Intrinsics.checkNotNull((Object)d);
                        double d2 = d;
                        Double d3 = y;
                        Intrinsics.checkNotNull((Object)d3);
                        DoubleVector newLoc = pos.translate(new DoubleVector(d2, d3.doubleValue()), p, geomCtx);
                        double adjustedX = newLoc.getX();
                        double adjustedY = newLoc.getY();
                        if (rangesInited) {
                            adjustedMinX = Math.min(adjustedX, adjustedMinX);
                            adjustedMaxX = Math.max(adjustedX, adjustedMaxX);
                            adjustedMinY = Math.min(adjustedY, adjustedMinY);
                            adjustedMaxY = Math.max(adjustedY, adjustedMaxY);
                        } else {
                            adjustedMinX = adjustedMaxX = adjustedX;
                            adjustedMinY = adjustedMaxY = adjustedY;
                            rangesInited = true;
                        }
                    }
                }
                --i;
            }
        }
        DoubleSpan xRange = rangesInited ? new DoubleSpan(adjustedMinX, adjustedMaxX) : null;
        DoubleSpan yRange = rangesInited ? new DoubleSpan(adjustedMinY, adjustedMaxY) : null;
        return new Pair((Object)xRange, (Object)yRange);
    }

    private final Pair<DoubleSpan, DoubleSpan> computeLayerDryRunXYRangesAfterSizeExpand(GeomLayer layer, Aesthetics aesthetics, GeomContext geomCtx) {
        DoubleSpan doubleSpan;
        DoubleSpan doubleSpan2;
        boolean isDiscrete;
        double resolution;
        Pair pair;
        boolean bl = layer.isYOrientation();
        if (bl) {
            pair = TuplesKt.to((Object)Aes.Companion.getY(), (Object)Aes.Companion.getX());
        } else if (!bl) {
            pair = TuplesKt.to((Object)Aes.Companion.getX(), (Object)Aes.Companion.getY());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        Aes widthAxis = (Aes)pair2.component1();
        Aes heightAxis = (Aes)pair2.component2();
        Geom geom2 = layer.getGeom();
        List renderedAes = GeomLayer.DefaultImpls.renderedAes$default(layer, false, 1, null);
        Pair[] pairArray = new Pair[2];
        if (geom2 instanceof WithWidth) {
            resolution = geomCtx.getResolution(widthAxis);
            isDiscrete = !((Scale)MapsKt.getValue(layer.getScaleMap(), (Object)widthAxis)).isContinuousDomain();
            doubleSpan2 = this.computeLayerDryRunRangeAfterSizeExpand(aesthetics, (Function1<? super DataPointAesthetics, DoubleSpan>)((Function1)new Function1<DataPointAesthetics, DoubleSpan>(geom2, (Aes<Double>)widthAxis, resolution, isDiscrete){
                final /* synthetic */ Geom $geom;
                final /* synthetic */ Aes<Double> $widthAxis;
                final /* synthetic */ double $resolution;
                final /* synthetic */ boolean $isDiscrete;
                {
                    this.$geom = $geom;
                    this.$widthAxis = $widthAxis;
                    this.$resolution = $resolution;
                    this.$isDiscrete = $isDiscrete;
                    super(1);
                }

                @Nullable
                public final DoubleSpan invoke(@NotNull DataPointAesthetics p) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    return ((WithWidth)this.$geom).widthSpan(p, this.$widthAxis, this.$resolution, this.$isDiscrete);
                }
            }));
        } else if (renderedAes.contains(Aes.Companion.getWIDTH())) {
            resolution = geomCtx.getResolution(widthAxis);
            doubleSpan2 = this.computeLayerDryRunRangeAfterSizeExpand(aesthetics, (Function1<? super DataPointAesthetics, DoubleSpan>)((Function1)new Function1<DataPointAesthetics, DoubleSpan>((Aes<Double>)widthAxis, resolution){
                final /* synthetic */ Aes<Double> $widthAxis;
                final /* synthetic */ double $resolution;
                {
                    this.$widthAxis = $widthAxis;
                    this.$resolution = $resolution;
                    super(1);
                }

                @Nullable
                public final DoubleSpan invoke(@NotNull DataPointAesthetics p) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    return PointDimensionsUtil.INSTANCE.dimensionSpan(p, this.$widthAxis, Aes.Companion.getWIDTH(), this.$resolution);
                }
            }));
        } else {
            doubleSpan2 = null;
        }
        pairArray[0] = TuplesKt.to((Object)widthAxis, doubleSpan2);
        if (geom2 instanceof WithHeight) {
            resolution = geomCtx.getResolution(heightAxis);
            isDiscrete = !((Scale)MapsKt.getValue(layer.getScaleMap(), (Object)heightAxis)).isContinuousDomain();
            doubleSpan = this.computeLayerDryRunRangeAfterSizeExpand(aesthetics, (Function1<? super DataPointAesthetics, DoubleSpan>)((Function1)new Function1<DataPointAesthetics, DoubleSpan>(geom2, (Aes<Double>)heightAxis, resolution, isDiscrete){
                final /* synthetic */ Geom $geom;
                final /* synthetic */ Aes<Double> $heightAxis;
                final /* synthetic */ double $resolution;
                final /* synthetic */ boolean $isDiscrete;
                {
                    this.$geom = $geom;
                    this.$heightAxis = $heightAxis;
                    this.$resolution = $resolution;
                    this.$isDiscrete = $isDiscrete;
                    super(1);
                }

                @Nullable
                public final DoubleSpan invoke(@NotNull DataPointAesthetics p) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    return ((WithHeight)this.$geom).heightSpan(p, this.$heightAxis, this.$resolution, this.$isDiscrete);
                }
            }));
        } else if (renderedAes.contains(Aes.Companion.getHEIGHT())) {
            resolution = geomCtx.getResolution(heightAxis);
            doubleSpan = this.computeLayerDryRunRangeAfterSizeExpand(aesthetics, (Function1<? super DataPointAesthetics, DoubleSpan>)((Function1)new Function1<DataPointAesthetics, DoubleSpan>((Aes<Double>)heightAxis, resolution){
                final /* synthetic */ Aes<Double> $heightAxis;
                final /* synthetic */ double $resolution;
                {
                    this.$heightAxis = $heightAxis;
                    this.$resolution = $resolution;
                    super(1);
                }

                @Nullable
                public final DoubleSpan invoke(@NotNull DataPointAesthetics p) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    return PointDimensionsUtil.INSTANCE.dimensionSpan(p, this.$heightAxis, Aes.Companion.getHEIGHT(), this.$resolution);
                }
            }));
        } else {
            doubleSpan = null;
        }
        pairArray[1] = TuplesKt.to((Object)heightAxis, doubleSpan);
        Map xy2 = MapsKt.mapOf((Pair[])pairArray);
        return new Pair(MapsKt.getValue((Map)xy2, (Object)Aes.Companion.getX()), MapsKt.getValue((Map)xy2, (Object)Aes.Companion.getY()));
    }

    private final DoubleSpan computeLayerDryRunRangeAfterSizeExpand(Aesthetics aesthetics, Function1<? super DataPointAesthetics, DoubleSpan> pointSpan) {
        DoubleSpan minMax = null;
        for (DataPointAesthetics p : aesthetics.dataPoints()) {
            DoubleSpan span = (DoubleSpan)pointSpan.invoke((Object)p);
            minMax = SeriesUtil.INSTANCE.span(minMax, span);
        }
        return minMax;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ=\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0002J#\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PositionalScalesUtil$RangeUtil;", "", "()V", "combineRanges", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "aesList", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "combineRanges$plot_builder", "expandRange", "range", "aes", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "layers", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "expandRange$plot_builder", "initialRange", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "updateRange", "values", "", "wasRange", "updateRange$plot_builder", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nPositionalScalesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionalScalesUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PositionalScalesUtil$RangeUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n766#2:417\n857#2,2:418\n1747#2,3:420\n*S KotlinDebug\n*F\n+ 1 PositionalScalesUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PositionalScalesUtil$RangeUtil\n*L\n352#1:417\n352#1:418,2\n371#1:420,3\n*E\n"})
    private static final class RangeUtil {
        @NotNull
        public static final RangeUtil INSTANCE = new RangeUtil();

        private RangeUtil() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DoubleSpan initialRange(@NotNull Transform transform) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
            Transform transform2 = transform;
            if (transform2 instanceof ContinuousTransform) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = TuplesKt.toList((Pair)ScaleUtil.INSTANCE.transformedDefinedLimits((ContinuousTransform)transform));
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    double it = ((Number)element$iv$iv).doubleValue();
                    boolean bl = false;
                    double d = it;
                    boolean bl2 = !Double.isInfinite(d) && !Double.isNaN(d);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List lims = (List)destination$iv$iv;
                object = lims.isEmpty() ? null : DoubleSpan.Companion.encloseAll((Iterable)lims);
            } else if (transform2 instanceof DiscreteTransform) {
                object = DoubleSpan.Companion.encloseAll((Iterable)((DiscreteTransform)transform).getEffectiveDomainTransformed());
            } else {
                throw new IllegalStateException("Unexpected transform type: " + Reflection.getOrCreateKotlinClass(transform.getClass()).getSimpleName());
            }
            return object;
        }

        @Nullable
        public final DoubleSpan expandRange$plot_builder(@Nullable DoubleSpan range, @NotNull Aes<Double> aes, @NotNull Scale scale, @NotNull List<? extends GeomLayer> layers) {
            DoubleSpan doubleSpan;
            boolean includeZero;
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter(aes, (String)"aes");
                Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
                Intrinsics.checkNotNullParameter(layers, (String)"layers");
                Iterable $this$any$iv = layers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GeomLayer it = (GeomLayer)element$iv;
                        boolean bl2 = false;
                        if (!it.rangeIncludesZero(aes)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            boolean bl3 = includeZero = bl;
            if (bl3) {
                doubleSpan = this.updateRange$plot_builder(DoubleSpan.Companion.singleton(0.0), range);
            } else if (!bl3) {
                doubleSpan = range;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DoubleSpan range2 = doubleSpan;
            return PlotUtil.INSTANCE.rangeWithExpand$plot_builder(range2, scale, includeZero);
        }

        private final DoubleSpan updateRange(Iterable<Double> values, DoubleSpan wasRange) {
            DoubleSpan newRange = DoubleSpan.Companion.encloseAll(values);
            return wasRange == null ? newRange : wasRange.union(newRange);
        }

        @Nullable
        public final DoubleSpan updateRange$plot_builder(@Nullable DoubleSpan range, @Nullable DoubleSpan wasRange) {
            DoubleSpan range2 = range;
            if (range2 != null) {
                if (wasRange != null) {
                    range2 = wasRange.union(range2);
                }
                return range2;
            }
            return wasRange;
        }

        @Nullable
        public final DoubleSpan combineRanges$plot_builder(@NotNull List<Aes<Double>> aesList, @NotNull Aesthetics aesthetics) {
            Intrinsics.checkNotNullParameter(aesList, (String)"aesList");
            Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
            DoubleSpan result = null;
            for (Aes<Double> aes : aesList) {
                DoubleSpan range = aesthetics.range(aes);
                if (range == null) continue;
                DoubleSpan doubleSpan = result;
                if (doubleSpan == null || (doubleSpan = doubleSpan.union(range)) == null) {
                    doubleSpan = range;
                }
                result = doubleSpan;
            }
            return result;
        }
    }
}

