/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

public class CPSPauser {
    private final int charactersPerSecond;
    private static final long MS_PER_SEC = 1000L;
    private static final long NS_PER_SEC = 1000000000L;
    private static final long NS_PER_MS = 1000000L;

    public CPSPauser(int cps) {
        if (cps <= 0) {
            throw new IllegalArgumentException("Speed (cps) <= 0");
        }
        this.charactersPerSecond = cps;
    }

    public void pause(int bytes) {
        long sleepMS = (long)bytes * 1000L / (long)this.charactersPerSecond;
        int sleepNS = Long.valueOf(sleepMS % 1000000L).intValue();
        try {
            if (sleepMS > 0L || sleepNS > 0) {
                Thread.sleep(sleepMS, sleepNS);
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

