/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.LoggerPanel;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.gui.TestPlanListener;
import org.apache.jmeter.gui.UndoHistory;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.TreeNodeNamingPolicy;
import org.apache.jmeter.gui.action.impl.DefaultTreeNodeNamingPolicy;
import org.apache.jmeter.gui.logging.GuiLogEventBus;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.JMeterToolBar;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.JFactory;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuiPackage
implements LocaleChangeListener,
UndoHistory.HistoryListener {
    private static final Logger log = LoggerFactory.getLogger(GuiPackage.class);
    private static final String LAF_EPOCH = "JMeter.laf_epoch";
    private static final String SBR_PREFS_KEY = "save_before_run";
    private static final String SAVE_BEFORE_RUN_PROPERTY = "save_automatically_before_run";
    private static final boolean SAVE_BEFORE_RUN_PROPERTY_DEFAULT_VALUE = true;
    private static final Preferences PREFS = Preferences.userNodeForPackage(GuiPackage.class);
    private static GuiPackage guiPack;
    private boolean dirty = false;
    private final IdentityHashMap<TestElement, JMeterGUIComponent> nodesToGui = new IdentityHashMap();
    private final Map<Class<?>, JMeterGUIComponent> guis = new HashMap();
    private final Map<Class<?>, JMeterGUIComponent> testBeanGUIs = new HashMap();
    private final AtomicInteger lafEpoch = new AtomicInteger();
    private JMeterTreeNode currentNode = null;
    private boolean currentNodeUpdated = false;
    private final JMeterTreeModel treeModel;
    private final JMeterTreeListener treeListener;
    private MainFrame mainFrame;
    private JToolBar toolbar;
    private JCheckBoxMenuItem menuItemLoggerPanel;
    private JCheckBoxMenuItem menuItemSaveBeforeRunPanel;
    private LoggerPanel loggerPanel;
    private final UndoHistory undoHistory = new UndoHistory();
    private final GuiLogEventBus logEventBus = new GuiLogEventBus();
    private final List<TestPlanListener> testPlanListeners = Collections.synchronizedList(new ArrayList());
    private String testPlanFile;
    private final List<Stoppable> stoppables = Collections.synchronizedList(new ArrayList());
    private TreeNodeNamingPolicy namingPolicy;

    private GuiPackage(JMeterTreeModel treeModel, JMeterTreeListener treeListener) {
        this.treeModel = treeModel;
        if (UndoHistory.isEnabled()) {
            this.treeModel.addTreeModelListener(this.undoHistory);
        }
        this.treeListener = treeListener;
    }

    public static GuiPackage getInstance() {
        return guiPack;
    }

    public void registerAsListener() {
        if (UndoHistory.isEnabled()) {
            this.undoHistory.registerHistoryListener(this);
        }
        JMeterUtils.addLocaleChangeListener(this);
    }

    public static void initInstance(JMeterTreeListener listener, JMeterTreeModel treeModel) {
        GuiPackage guiPack = new GuiPackage(treeModel, listener);
        guiPack.undoHistory.add(treeModel, "Created");
        GuiPackage.guiPack = guiPack;
    }

    public JMeterGUIComponent getGui(TestElement node) {
        String testClassName = node.getPropertyAsString("TestElement.test_class");
        String guiClassName = node.getPropertyAsString("TestElement.gui_class");
        try {
            Class<?> testClass = testClassName.isEmpty() ? node.getClass() : Class.forName(testClassName);
            Class<?> guiClass = null;
            if (!guiClassName.isEmpty()) {
                guiClass = Class.forName(guiClassName);
            }
            return this.getGui(node, guiClass, testClass);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not get GUI for {}", (Object)node, (Object)e);
            return null;
        }
    }

    public JMeterGUIComponent getGui(TestElement node, Class<?> guiClass, Class<?> testClass) {
        try {
            JMeterGUIComponent comp = this.nodesToGui.get(node);
            if (comp == null) {
                comp = this.getGuiFromCache(guiClass, testClass);
                this.nodesToGui.put(node, comp);
            } else {
                this.updateUi(comp);
            }
            log.debug("Gui retrieved = {}", (Object)comp);
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    @API(since="5.3", status=API.Status.MAINTAINED)
    public void removeNode(TestElement node) {
        this.nodesToGui.remove(node);
    }

    public JMeterGUIComponent getCurrentGui() {
        try {
            this.updateCurrentNode();
            TestElement curNode = this.treeListener.getCurrentNode().getTestElement();
            JMeterGUIComponent comp = this.getGui(curNode);
            if (comp == null) {
                log.debug("No Component found for {}.", (Object)this.treeListener.getCurrentNode().getName());
                return null;
            }
            comp.clearGui();
            log.debug("Updating gui to new node");
            comp.configure(curNode);
            this.currentNodeUpdated = false;
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving current gui", (Throwable)e);
            return null;
        }
    }

    public JMeterTreeNode getNodeOf(TestElement userObject) {
        return this.treeModel.getNodeOf(userObject);
    }

    public TestElement createTestElement(Class<?> guiClass, Class<?> testClass) {
        try {
            JMeterGUIComponent comp = this.getGuiFromCache(guiClass, testClass);
            comp.clearGui();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public TestElement createTestElement(String objClass) {
        try {
            Class<?> c = Class.forName(objClass);
            JMeterGUIComponent comp = TestBean.class.isAssignableFrom(c) ? this.getGuiFromCache(TestBeanGUI.class, c) : this.getGuiFromCache(c, null);
            comp.clearGui();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (NoClassDefFoundError e) {
            log.error("Problem retrieving gui for {}", (Object)objClass, (Object)e);
            String msg = "Cannot find class: " + e.getMessage();
            JOptionPane.showMessageDialog(null, msg, "Missing jar? See log file.", 0);
            throw new RuntimeException(e.toString(), e);
        }
        catch (ReflectiveOperationException e) {
            log.error("Problem retrieving gui for {}", (Object)objClass, (Object)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    private JMeterGUIComponent getGuiFromCache(Class<?> guiClass, Class<?> testClass) throws ReflectiveOperationException {
        JMeterGUIComponent comp;
        if (guiClass == TestBeanGUI.class) {
            comp = this.testBeanGUIs.get(testClass);
            if (comp == null) {
                comp = new TestBeanGUI(testClass);
                this.testBeanGUIs.put(testClass, comp);
            }
        } else {
            comp = this.guis.get(guiClass);
            if (comp == null && !((comp = (JMeterGUIComponent)guiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) instanceof UnsharedComponent)) {
                this.guis.put(guiClass, comp);
            }
        }
        this.updateUi(comp);
        return comp;
    }

    private void updateUi(JMeterGUIComponent comp) {
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent jc = (JComponent)((Object)comp);
        Object epoch = jc.getClientProperty(LAF_EPOCH);
        int currentLafEpoch = this.lafEpoch.get();
        if (epoch instanceof Integer && (Integer)epoch < currentLafEpoch) {
            JFactory.updateUi((JComponent)jc);
        }
        jc.putClientProperty(LAF_EPOCH, currentLafEpoch);
    }

    public void updateCurrentGui() {
        this.updateCurrentNode();
        this.refreshCurrentGui();
    }

    public void refreshCurrentGui() {
        this.currentNode = this.treeListener.getCurrentNode();
        TestElement element = this.currentNode.getTestElement();
        JMeterGUIComponent comp = this.getGui(element);
        if (comp == null) {
            log.debug("No component found for {}", (Object)this.currentNode.getName());
            return;
        }
        comp.configure(element);
        this.currentNodeUpdated = false;
    }

    public void updateCurrentNode() {
        try {
            if (this.currentNode != null && !this.currentNodeUpdated) {
                log.debug("Updating current node {}", (Object)this.currentNode.getName());
                JMeterGUIComponent comp = this.getGui(this.currentNode.getTestElement());
                if (comp == null) {
                    log.debug("No component found for {}", (Object)this.currentNode.getName());
                    return;
                }
                TestElement el = this.currentNode.getTestElement();
                int before = 0;
                int after = 0;
                boolean historyEnabled = UndoHistory.isEnabled();
                if (historyEnabled) {
                    before = GuiPackage.getTestElementCheckSum(el);
                }
                comp.modifyTestElement(el);
                if (historyEnabled) {
                    after = GuiPackage.getTestElementCheckSum(el);
                }
                if (!historyEnabled || before != after) {
                    this.currentNode.nameChanged();
                }
            }
            this.currentNodeUpdated = true;
            this.currentNode = this.treeListener.getCurrentNode();
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
        }
    }

    public JMeterTreeNode getCurrentNode() {
        return this.treeListener.getCurrentNode();
    }

    public TestElement getCurrentElement() {
        return this.getCurrentNode().getTestElement();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public HashTree addSubTree(HashTree subTree) throws IllegalUserActionException {
        HashTree hashTree = this.treeModel.addSubTree(subTree, this.treeListener.getCurrentNode());
        this.undoHistory.clear();
        this.undoHistory.add(this.treeModel, "Loaded tree");
        return hashTree;
    }

    public HashTree getCurrentSubTree() {
        return this.treeModel.getCurrentSubTree(this.treeListener.getCurrentNode());
    }

    public JMeterTreeModel getTreeModel() {
        return this.treeModel;
    }

    public ValueReplacer getReplacer() {
        return new ValueReplacer((TestPlan)((JMeterTreeNode)this.getTreeModel().getTestPlan().getArray()[0]).getTestElement());
    }

    public void setMainFrame(MainFrame newMainFrame) {
        this.mainFrame = newMainFrame;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public JMeterTreeListener getTreeListener() {
        return this.treeListener;
    }

    public void setMainToolbar(JToolBar newToolbar) {
        this.toolbar = newToolbar;
    }

    public JToolBar getMainToolbar() {
        return this.toolbar;
    }

    public void displayPopUp(MouseEvent e, JPopupMenu popup) {
        this.displayPopUp((Component)e.getSource(), e, popup);
    }

    public void displayPopUp(Component invoker, MouseEvent e, JPopupMenu popup) {
        if (popup != null) {
            log.debug("Showing pop up for {} at x,y = {},{}", new Object[]{invoker, e.getX(), e.getY()});
            popup.setLightWeightPopupEnabled(false);
            popup.show(invoker, e.getX(), e.getY());
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent event) {
        this.updateCurrentNode();
        Introspector.flushCaches();
        this.invalidateCachedUi();
    }

    public void invalidateCachedUi() {
        this.updateCurrentNode();
        this.guis.clear();
        this.nodesToGui.clear();
        this.testBeanGUIs.clear();
        ActionRouter.getInstance().actionPerformed(new ActionEvent(this, 3334, "edit"));
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public void updateUIForHiddenComponents() {
        this.lafEpoch.getAndIncrement();
    }

    public void setTestPlanFile(String f) {
        this.testPlanFile = f;
        this.getMainFrame().setExtendedFrameTitle(this.testPlanFile);
        this.getMainFrame().setFileRevertEnabled(f != null);
        this.getMainFrame().setProjectFileLoaded(f);
        try {
            FileServer.getFileServer().setBasedir(this.testPlanFile);
        }
        catch (IllegalStateException e1) {
            log.error("Failure setting file server's base dir", (Throwable)e1);
        }
        this.testPlanListeners.stream().forEach(TestPlanListener::testPlanLoaded);
    }

    public String getTestPlanFile() {
        return this.testPlanFile;
    }

    public void clearTestPlan() {
        this.testPlanListeners.stream().forEach(TestPlanListener::beforeTestPlanCleared);
        this.getTreeModel().clearTestPlan();
        this.nodesToGui.clear();
        this.setTestPlanFile(null);
        this.testPlanListeners.stream().forEach(TestPlanListener::afterTestPlanCleared);
        this.undoHistory.clear();
        this.undoHistory.add(this.treeModel, "Initial Tree");
    }

    public void clearTestPlan(TestElement element) {
        this.getTreeModel().clearTestPlan(element);
        this.removeNode(element);
        this.undoHistory.clear();
        this.undoHistory.add(this.treeModel, "Initial Tree");
    }

    public static void showErrorMessage(String message, String title) {
        GuiPackage.showMessage(message, title, 0);
    }

    public static void showInfoMessage(String message, String title) {
        GuiPackage.showMessage(message, title, 1);
    }

    public static void showWarningMessage(String message, String title) {
        GuiPackage.showMessage(message, title, 2);
    }

    public static void showMessage(String message, String title, int type) {
        if (guiPack == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, message, title, type));
    }

    public void unregister(Stoppable stoppableToUnregister) {
        this.stoppables.removeIf(stoppable -> stoppable == stoppableToUnregister);
    }

    public void register(Stoppable stoppable) {
        this.stoppables.add(stoppable);
    }

    public List<Stoppable> getStoppables() {
        ArrayList<Stoppable> list = new ArrayList<Stoppable>();
        list.addAll(this.stoppables);
        return list;
    }

    public void setMenuItemLoggerPanel(JCheckBoxMenuItem menuItemLoggerPanel) {
        this.menuItemLoggerPanel = menuItemLoggerPanel;
    }

    public JCheckBoxMenuItem getMenuItemLoggerPanel() {
        return this.menuItemLoggerPanel;
    }

    public void setMenuItemSaveBeforeRunPanel(JCheckBoxMenuItem menuItemSaveBeforeRunPanel) {
        this.menuItemSaveBeforeRunPanel = menuItemSaveBeforeRunPanel;
    }

    public JCheckBoxMenuItem getMenuItemSaveBeforeRunPanel() {
        return this.menuItemSaveBeforeRunPanel;
    }

    public void setLoggerPanel(LoggerPanel loggerPanel) {
        this.loggerPanel = loggerPanel;
    }

    public LoggerPanel getLoggerPanel() {
        return this.loggerPanel;
    }

    public void undo() {
        this.undoHistory.undo();
    }

    public void redo() {
        this.undoHistory.redo();
    }

    public boolean canRedo() {
        return this.undoHistory.canRedo();
    }

    public boolean canUndo() {
        return this.undoHistory.canUndo();
    }

    private static int getTestElementCheckSum(TestElement el) {
        int ret = el.getClass().hashCode();
        PropertyIterator it = el.propertyIterator();
        while (it.hasNext()) {
            JMeterProperty obj = it.next();
            if (obj instanceof TestElementProperty) {
                ret ^= GuiPackage.getTestElementCheckSum(((TestElementProperty)obj).getElement());
                continue;
            }
            ret ^= obj.getName().hashCode();
            String stringValue = obj.getStringValue();
            if (stringValue != null) {
                ret ^= stringValue.hashCode();
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("obj.getStringValue() returned null for test element:{} at property:{}", (Object)el.getName(), (Object)obj.getName());
        }
        return ret;
    }

    @Override
    public void notifyChangeInHistory(UndoHistory history) {
        ((JMeterToolBar)this.toolbar).updateUndoRedoIcons(history.canUndo(), history.canRedo());
    }

    public TreeNodeNamingPolicy getNamingPolicy() {
        if (this.namingPolicy == null) {
            String namingPolicyImplementation = JMeterUtils.getPropDefault("naming_policy.impl", DefaultTreeNodeNamingPolicy.class.getName());
            try {
                Class<?> implementationClass = Class.forName(namingPolicyImplementation);
                this.namingPolicy = (TreeNodeNamingPolicy)implementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                log.error("Failed to create configured naming policy:{}, will use default one", (Object)namingPolicyImplementation, (Object)ex);
                this.namingPolicy = new DefaultTreeNodeNamingPolicy();
            }
        }
        return this.namingPolicy;
    }

    public GuiLogEventBus getLogEventBus() {
        return this.logEventBus;
    }

    public void beginUndoTransaction() {
        this.undoHistory.beginUndoTransaction();
    }

    public void endUndoTransaction() {
        this.undoHistory.endUndoTransaction();
    }

    public boolean shouldSaveBeforeRunByPreference() {
        return Boolean.TRUE.toString().equalsIgnoreCase(PREFS.get(SBR_PREFS_KEY, null));
    }

    public void setSaveBeforeRunByPreference(boolean saveBeforeRun) {
        PREFS.put(SBR_PREFS_KEY, Boolean.toString(saveBeforeRun));
    }

    public boolean shouldSaveBeforeRun() {
        String sbr = PREFS.get(SBR_PREFS_KEY, null);
        if (sbr == null) {
            return JMeterUtils.getPropDefault(SAVE_BEFORE_RUN_PROPERTY, true);
        }
        return this.shouldSaveBeforeRunByPreference();
    }

    public void addTestPlanListener(TestPlanListener listener) {
        this.testPlanListeners.add(listener);
    }

    public void removeTestPlanListener(TestPlanListener listener) {
        this.testPlanListeners.remove(listener);
    }
}

