/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;

public abstract class AbstractFunction
implements Function {
    @Override
    public abstract String execute(SampleResult var1, Sampler var2) throws InvalidVariableException;

    public String execute() throws InvalidVariableException {
        JMeterContext context = JMeterContextService.getContext();
        SampleResult previousResult = context.getPreviousResult();
        Sampler currentSampler = context.getCurrentSampler();
        return this.execute(previousResult, currentSampler);
    }

    @Override
    public abstract void setParameters(Collection<CompoundVariable> var1) throws InvalidVariableException;

    @Override
    public abstract String getReferenceKey();

    protected JMeterVariables getVariables() {
        return JMeterContextService.getContext().getVariables();
    }

    protected void checkParameterCount(Collection<CompoundVariable> parameters, int min, int max) throws InvalidVariableException {
        int num = parameters.size();
        if (num > max || num < min) {
            throw new InvalidVariableException(this.getReferenceKey() + " called with wrong number of parameters. Actual: " + num + (min == max ? ". Expected: " + min + "." : ". Expected: >= " + min + " and <= " + max));
        }
    }

    protected void checkParameterCount(Collection<CompoundVariable> parameters, int count) throws InvalidVariableException {
        int num = parameters.size();
        if (num != count) {
            throw new InvalidVariableException(this.getReferenceKey() + " called with wrong number of parameters. Actual: " + num + ". Expected: " + count + ".");
        }
    }

    protected void checkMinParameterCount(Collection<CompoundVariable> parameters, int minimum) throws InvalidVariableException {
        int num = parameters.size();
        if (num < minimum) {
            throw new InvalidVariableException(this.getReferenceKey() + " called with wrong number of parameters. Actual: " + num + ". Expected at least: " + minimum + ".");
        }
    }

    protected final void addVariableValue(String value, CompoundVariable[] values, int index) {
        JMeterVariables vars;
        String variableName;
        if (values.length > index && StringUtils.isNotEmpty((CharSequence)(variableName = values[index].execute().trim())) && (vars = this.getVariables()) != null) {
            vars.put(variableName, value);
        }
    }
}

