/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.ArrayMathFunction;
import java.util.List;

public class SumFunction
extends ArrayMathFunction {
    public SumFunction() {
        super(ArgumentConstraints.typeOf(JmesPathType.NUMBER));
    }

    @Override
    protected <T> T performMathOperation(Adapter<T> runtime, List<T> values) {
        double sum = 0.0;
        for (T n : values) {
            sum += runtime.toNumber(n).doubleValue();
        }
        return runtime.createNumber(sum);
    }
}

