/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.nodetable;

import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TReadAppendFileTransport
extends TTransport {
    private BinaryDataFile file;
    private long readPosn = -1L;

    public TReadAppendFileTransport(BinaryDataFile file) {
        Objects.requireNonNull(file);
        this.file = file;
    }

    public boolean isOpen() {
        return this.file.isOpen();
    }

    public void open() {
        this.file.open();
    }

    public void close() {
        this.file.close();
    }

    public void truncate(long posn) {
        this.file.truncate(posn);
    }

    public BinaryDataFile getBinaryDataFile() {
        return this.file;
    }

    public long readPosition() {
        return this.readPosn;
    }

    public void readPosition(long posn) {
        this.readPosn = posn;
    }

    public int read(byte[] buf, int off, int len) {
        int x = this.file.read(this.readPosn, buf, off, len);
        this.readPosn += (long)x;
        return x;
    }

    public void write(byte[] buf, int off, int len) {
        this.file.write(buf, off, len);
    }

    public void flush() {
        this.file.sync();
    }

    public TConfiguration getConfiguration() {
        throw new NotImplementedException("TReadAppendFileTransport.getConfiguration");
    }

    public void updateKnownMessageSize(long size) throws TTransportException {
    }

    public void checkReadBytesAvailable(long numBytes) throws TTransportException {
    }
}

