/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.projections;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.jmap.postgres.projections.PostgresEmailQueryViewDataDefinition;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.util.streams.Limit;
import org.jooq.OrderField;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresEmailQueryViewDAO {
    private PostgresExecutor postgresExecutor;

    @Inject
    public PostgresEmailQueryViewDAO(@Named(value="by_pass_rls") PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Flux<MessageId> listMailboxContentSortedBySentAt(PostgresMailboxId mailboxId, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID).from(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).where(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).orderBy((OrderField)PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.SENT_AT.desc()).limit((Number)limit.getLimit().get()))).map(record -> PostgresMessageId.Factory.of((UUID)((UUID)record.get(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID))));
    }

    public Flux<MessageId> listMailboxContentSortedByReceivedAt(PostgresMailboxId mailboxId, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID).from(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).where(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).orderBy((OrderField)PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.RECEIVED_AT.desc()).limit((Number)limit.getLimit().get()))).map(record -> PostgresMessageId.Factory.of((UUID)((UUID)record.get(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID))));
    }

    public Flux<MessageId> listMailboxContentSinceAfterSortedBySentAt(PostgresMailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID).from(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).where(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.RECEIVED_AT.greaterOrEqual((Object)since.toOffsetDateTime())).orderBy((OrderField)PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.SENT_AT.desc()).limit((Number)limit.getLimit().get()))).map(record -> PostgresMessageId.Factory.of((UUID)((UUID)record.get(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID))));
    }

    public Flux<MessageId> listMailboxContentSinceAfterSortedByReceivedAt(PostgresMailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID).from(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).where(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.RECEIVED_AT.greaterOrEqual((Object)since.toOffsetDateTime())).orderBy((OrderField)PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.RECEIVED_AT.desc()).limit((Number)limit.getLimit().get()))).map(record -> PostgresMessageId.Factory.of((UUID)((UUID)record.get(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID))));
    }

    public Flux<MessageId> listMailboxContentBeforeSortedByReceivedAt(PostgresMailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID).from(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).where(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.RECEIVED_AT.lessOrEqual((Object)since.toOffsetDateTime())).orderBy((OrderField)PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.RECEIVED_AT.desc()).limit((Number)limit.getLimit().get()))).map(record -> PostgresMessageId.Factory.of((UUID)((UUID)record.get(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID))));
    }

    public Flux<MessageId> listMailboxContentSinceSentAt(PostgresMailboxId mailboxId, ZonedDateTime since, Limit limit) {
        Preconditions.checkArgument((!limit.isUnlimited() ? 1 : 0) != 0, (Object)"Limit should be defined");
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID).from(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).where(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.SENT_AT.greaterOrEqual((Object)since.toOffsetDateTime())).orderBy((OrderField)PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.SENT_AT.desc()).limit((Number)limit.getLimit().get()))).map(record -> PostgresMessageId.Factory.of((UUID)((UUID)record.get(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID))));
    }

    public Mono<Void> delete(PostgresMailboxId mailboxId, PostgresMessageId messageId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).where(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).and(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID.eq((Object)messageId.asUuid()))));
    }

    public Mono<Void> delete(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).where(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID.eq((Object)mailboxId.asUuid()))));
    }

    public Mono<Void> save(PostgresMailboxId mailboxId, ZonedDateTime sentAt, ZonedDateTime receivedAt, PostgresMessageId messageId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.TABLE_NAME).set(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MAILBOX_ID, (Object)mailboxId.asUuid()).set(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.MESSAGE_ID, (Object)messageId.asUuid()).set(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.SENT_AT, (Object)sentAt.toOffsetDateTime()).set(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.RECEIVED_AT, (Object)receivedAt.toOffsetDateTime()).onConflictOnConstraint(PostgresEmailQueryViewDataDefinition.PostgresEmailQueryViewTable.PK_CONSTRAINT_NAME).doNothing()));
    }
}

